/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.html;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class DarkHTML
extends BasicHTML {
    public static int getBaseline(View view, int w, int h) {
        if (DarkHTML.hasParagraph(view)) {
            view.setSize(w, h);
            return DarkHTML.getBaseline(view, new Rectangle(0, 0, w, h));
        }
        return -1;
    }

    private static int getBaseline(View view, Shape bounds) {
        if (view.getViewCount() == 0) {
            return -1;
        }
        AttributeSet attributes = view.getElement().getAttributes();
        Object name = null;
        if (attributes != null) {
            name = attributes.getAttribute(StyleConstants.NameAttribute);
        }
        int index = 0;
        if (name == HTML.Tag.HTML && view.getViewCount() > 1) {
            ++index;
        }
        if ((bounds = view.getChildAllocation(index, bounds)) == null) {
            return -1;
        }
        View child = view.getView(index);
        if (view instanceof ParagraphView) {
            Rectangle rect = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            return rect.y + (int)((float)rect.height * child.getAlignment(1));
        }
        return DarkHTML.getBaseline(child, bounds);
    }

    private static boolean hasParagraph(View view) {
        if (view instanceof ParagraphView) {
            return true;
        }
        if (view.getViewCount() == 0) {
            return false;
        }
        AttributeSet attributes = view.getElement().getAttributes();
        Object name = null;
        if (attributes != null) {
            name = attributes.getAttribute(StyleConstants.NameAttribute);
        }
        int index = 0;
        if (name == HTML.Tag.HTML && view.getViewCount() > 1) {
            index = 1;
        }
        return DarkHTML.hasParagraph(view.getView(index));
    }
}

