/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class DarkDesktopIconUI
extends BasicDesktopIconUI {
    protected JButton button;
    protected JLabel label;
    protected TitleListener titleListener;
    protected int width;

    public static ComponentUI createUI(JComponent c) {
        return new DarkDesktopIconUI();
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String title = this.frame.getTitle();
        this.button = new JButtonUIResource(title, icon);
        this.button.setOpaque(false);
        this.button.setFocusable(false);
        this.button.putClientProperty("JButton.variant", "borderlessRectangular");
        this.button.putClientProperty("JButton.borderless.hover", UIManager.getColor("DesktopIcon.hoverColor"));
        this.button.putClientProperty("JButton.borderless.click", UIManager.getColor("DesktopIcon.hoverColor"));
        this.button.setRolloverEnabled(true);
        this.button.addActionListener(e -> this.deiconize());
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        Icon drag = UIManager.getIcon("DesktopIcon.drag.icon");
        this.label = new JLabel(drag);
        this.label.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
        this.desktopIcon.setLayout(new BorderLayout(2, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.label, "West");
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.label);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    @Override
    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, 28);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("title")) {
                DarkDesktopIconUI.this.button.setText((String)e.getNewValue());
            }
            if (e.getPropertyName().equals("frameIcon")) {
                DarkDesktopIconUI.this.button.setIcon((Icon)e.getNewValue());
            }
        }
    }
}

