/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.components.ScrollPopupMenu;
import com.github.weisj.darklaf.ui.popupmenu.MouseGrabberUtil;
import com.github.weisj.darklaf.ui.popupmenu.PopupMenuContainer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Graphics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class DarkPopupMenuUI
extends BasicPopupMenuUI {
    public static final String KEY_DO_NOT_CANCEL_POPUP = "doNotCancelPopup";
    public static final String KEY_DO_NOT_CANCEL_ON_SCROLL = "doNotCancelOnScroll";
    public static final String HIDE_POPUP_VALUE = "doNotCancelPopup";
    public static final String KEY_DEFAULT_LIGHTWEIGHT_POPUPS = "PopupMenu.defaultLightWeightPopups";
    private PopupMenuContainer popupMenuContainer;

    public static ComponentUI createUI(JComponent x) {
        return new DarkPopupMenuUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window != null && PropertyUtil.getBooleanProperty((JComponent)this.popupMenu, (String)"JPopupFactory.makeVisible")) {
            this.popupMenu.putClientProperty("JPopupFactory.makeVisible", false);
            window.setOpacity(1.0f);
        }
        super.paint(g, c);
    }

    public static List<JPopupMenu> getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (MenuElement element : p) {
            if (!(element instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)element);
        }
        return list;
    }

    @Override
    public void installDefaults() {
        if (!(this.popupMenu instanceof ScrollPopupMenu)) {
            this.popupMenuContainer = new PopupMenuContainer();
        }
        super.installDefaults();
        this.popupMenu.putClientProperty("JPopupFactory.startHidden", true);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        MouseGrabberUtil.installMouseGrabber();
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        if (this.popupMenuContainer == null) {
            return super.getPopup(popup, x, y);
        }
        int maxHeight = DarkUIUtil.getScreenBounds((JComponent)popup, (int)x, (int)y, (boolean)false).height;
        return this.popupMenuContainer.createPopup(popup, x, y, maxHeight);
    }
}

