/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarListener;
import com.github.weisj.darklaf.ui.scrollpane.EmptyButton;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarConstants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class DarkScrollBarUI
extends BasicScrollBarUI
implements ScrollBarConstants {
    private static final float THUMB_ALPHA = 0.6f;
    private static final AlphaComposite COMPOSITE = AlphaComposite.getInstance(3);
    protected DarkScrollBarListener scrollBarListener;
    protected Color thumbBorderColor;
    protected Color thumbFadeStartColor;
    protected Color thumbFadeEndColor;
    protected Color trackBackground;
    protected int smallSize;
    protected int size;

    public static ComponentUI createUI(JComponent c) {
        return new DarkScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.setFocusable(false);
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        this.thumbBorderColor = UIManager.getColor("ScrollBar.thumbBorderColor");
        this.thumbFadeStartColor = UIManager.getColor("ScrollBar.fadeStartColor");
        this.thumbFadeEndColor = UIManager.getColor("ScrollBar.fadeEndColor");
        this.trackBackground = UIManager.getColor("ScrollBar.trackColor");
        this.smallSize = UIManager.getInt("ScrollBar.smallWidth");
        this.size = UIManager.getInt("ScrollBar.width");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.scrollBarListener = this.createScrollBarListener();
        this.scrollbar.addAdjustmentListener(this.scrollBarListener);
        this.scrollbar.addMouseMotionListener(this.scrollBarListener);
        this.scrollbar.addMouseListener(this.scrollBarListener);
        this.scrollbar.addMouseWheelListener(this.scrollBarListener);
    }

    protected DarkScrollBarListener createScrollBarListener() {
        return new DarkScrollBarListener(this.scrollbar, this);
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DarkScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeMouseListener(this.scrollBarListener);
        this.scrollbar.removeMouseWheelListener(this.scrollBarListener);
        this.scrollbar.removeMouseMotionListener(this.scrollBarListener);
        this.scrollbar.removeAdjustmentListener(this.scrollBarListener);
        this.scrollBarListener.uninstall();
        this.scrollBarListener = null;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
        float trackAlpha;
        if (c.isOpaque()) {
            g.setColor(this.scrollbar.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if ((trackAlpha = this.scrollBarListener.getTrackAlpha()) == 0.0f) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getTrackColor());
        g2.setComposite(COMPOSITE.derive(trackAlpha));
        g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g2.dispose();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!thumbBounds.isEmpty() && this.scrollbar.isEnabled()) {
            this.paintMaxiThumb((Graphics2D)g, thumbBounds);
        }
    }

    protected void paintMaxiThumb(Graphics2D g, Rectangle rect) {
        Composite c = g.getComposite();
        g.setComposite(COMPOSITE.derive(0.6f));
        Color thumbColor = this.getThumbColor();
        float thumbAlpha = this.scrollBarListener.getThumbAlpha();
        double percent = Math.min(1.0, Math.max(0.0, (double)(1.0f - (thumbAlpha - 0.6f))));
        g.setColor(PaintUtil.blendColors(this.thumbBorderColor, thumbColor, percent));
        PaintUtil.drawRect(g, rect.x, rect.y, rect.width, rect.height, 1);
        g.setColor(thumbColor);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g.setComposite(c);
    }

    protected Color getThumbColor() {
        return PaintUtil.blendColors(this.thumbFadeEndColor, this.thumbFadeStartColor, this.scrollBarListener.getThumbAlpha());
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color getTrackColor() {
        return this.trackBackground;
    }

    protected int getThickness() {
        return ScrollBarConstants.isSmall(this.scrollbar) ? this.smallSize : this.size;
    }

    @Override
    public Rectangle getTrackBounds() {
        return super.getTrackBounds();
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMinimumThumbSize();
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int size = this.getThickness();
        return new Dimension(size, size);
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

