/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.ui.scrollpane.ScrollBarConstants;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class ScrollBarUtil
implements ScrollBarConstants {
    public static void doScroll(JScrollBar toScroll, JViewport vp, MouseWheelEvent e, boolean leftToRight) {
        int direction = e.getWheelRotation() < 0 ? -1 : 1;
        int orientation = toScroll.getOrientation();
        if (!leftToRight && orientation == 0) {
            direction *= -1;
        }
        if (e.getScrollType() == 0) {
            Component comp;
            int units = Math.abs(e.getUnitsToScroll());
            boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
            Component component = comp = vp == null ? null : vp.getView();
            if (comp instanceof Scrollable && PropertyUtil.getBooleanProperty((JComponent)toScroll, (String)"JScrollBar.fastWheelScrolling")) {
                Scrollable scrollComp = (Scrollable)((Object)comp);
                Rectangle viewRect = vp.getViewRect();
                int startingX = viewRect.x;
                int scrollMin = toScroll.getMinimum();
                int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                if (limitScroll) {
                    int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                    if (direction < 0) {
                        scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                    } else {
                        scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                    }
                }
                for (int i = 0; i < units; ++i) {
                    int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                    if (orientation == 1) {
                        if (direction < 0) {
                            viewRect.y -= unitIncr;
                            if (viewRect.y > scrollMin) continue;
                            viewRect.y = scrollMin;
                            break;
                        }
                        viewRect.y += unitIncr;
                        if (viewRect.y < scrollMax) continue;
                        viewRect.y = scrollMax;
                        break;
                    }
                    if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                        viewRect.x -= unitIncr;
                        if (!leftToRight || viewRect.x >= scrollMin) continue;
                        viewRect.x = scrollMin;
                        break;
                    }
                    viewRect.x += unitIncr;
                    if (!leftToRight || viewRect.x <= scrollMax) continue;
                    viewRect.x = scrollMax;
                    break;
                }
                if (orientation == 1) {
                    toScroll.setValue(viewRect.y);
                } else if (leftToRight) {
                    toScroll.setValue(viewRect.x);
                } else {
                    int newPos = toScroll.getValue() - (viewRect.x - startingX);
                    if (newPos < scrollMin) {
                        newPos = scrollMin;
                    } else if (newPos > scrollMax) {
                        newPos = scrollMax;
                    }
                    toScroll.setValue(newPos);
                }
            } else {
                ScrollBarUtil.scrollByUnits(toScroll, direction, units, limitScroll);
            }
        } else if (e.getScrollType() == 1) {
            ScrollBarUtil.scrollByBlock(toScroll, direction);
        }
    }

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units, boolean limitToBlock) {
        int limit = -1;
        if (limitToBlock) {
            limit = direction < 0 ? scrollbar.getValue() - scrollbar.getBlockIncrement(direction) : scrollbar.getValue() + scrollbar.getBlockIncrement(direction);
        }
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            if (limitToBlock && i > 0) {
                assert (limit != -1);
                if (direction < 0 && newValue < limit || direction > 0 && newValue > limit) break;
            }
            scrollbar.setValue(newValue);
        }
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }
}

