/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneLayout;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DarkTabbedPaneLayout
extends TabbedPaneLayout {
    private final DarkTabbedPaneUI ui;

    public DarkTabbedPaneLayout(DarkTabbedPaneUI ui) {
        super(ui);
        this.ui = ui;
    }

    @Override
    protected void centerTabs(int tabPlacement, int tabCount, int returnAt) {
        block4: {
            if (this.ui.runCount != 1 || !PropertyUtil.getBooleanProperty((JComponent)this.ui.tabPane, (String)"JTabbedPane.centerTabs")) break block4;
            if (this.ui.isHorizontalTabPlacement()) {
                int shift = (returnAt - (this.ui.rects[tabCount - 1].x + this.ui.rects[tabCount - 1].width)) / 2;
                for (int i = 0; i < tabCount; ++i) {
                    this.ui.rects[i].x += shift;
                }
            } else {
                int shift = (returnAt - (this.ui.rects[tabCount - 1].y + this.ui.rects[tabCount - 1].height)) / 2;
                for (int i = 0; i < tabCount; ++i) {
                    this.ui.rects[i].y += shift;
                }
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int selectedIndex = this.ui.tabPane.getSelectedIndex();
        Component visibleComponent = this.ui.getVisibleComponent();
        this.calculateLayoutInfo();
        Component selectedComponent = null;
        if (selectedIndex < 0) {
            if (visibleComponent != null) {
                this.ui.setVisibleComponent(null);
            }
        } else {
            selectedComponent = this.ui.tabPane.getComponentAt(selectedIndex);
        }
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        boolean shouldChangeFocus = false;
        if (selectedComponent != null) {
            Component owner;
            if (selectedComponent != visibleComponent && visibleComponent != null && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, visibleComponent)) {
                shouldChangeFocus = true;
            }
            this.ui.setVisibleComponent(selectedComponent);
        }
        Rectangle bounds = this.ui.tabPane.getBounds();
        int numChildren = this.ui.tabPane.getComponentCount();
        if (numChildren > 0) {
            int ch;
            int cw;
            int cy;
            int cx;
            int th;
            int ty;
            int tx;
            int tw;
            switch (tabPlacement) {
                case 2: {
                    tw = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    th = bounds.height - insets.top - tabAreaInsets.top - insets.bottom - tabAreaInsets.bottom;
                    cx = insets.left + tw + contentInsets.left + tabAreaInsets.left + tabAreaInsets.right;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right - tw - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 4: {
                    tw = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    tx = bounds.width - insets.left - tw - tabAreaInsets.right - tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    th = bounds.height - insets.top - tabAreaInsets.top - insets.bottom - tabAreaInsets.bottom;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right - tw - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 3: {
                    th = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    ty = bounds.height - insets.bottom - th;
                    tx = insets.left + tabAreaInsets.left;
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - th - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                default: {
                    ty = insets.top + tabAreaInsets.top;
                    tx = insets.left + tabAreaInsets.left;
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + th + contentInsets.top + tabAreaInsets.top + tabAreaInsets.bottom;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - th - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                }
            }
            this.ui.tabAreaBounds.setRect(tx, ty, tw, th);
            for (int i = 0; i < numChildren; ++i) {
                Component child = this.ui.tabPane.getComponent(i);
                if (child == this.ui.tabContainer) {
                    child.setBounds(tx, ty, tw, th);
                    continue;
                }
                int tabHeight = this.ui.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                int tabWidth = this.ui.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                int compHeight = ch;
                int compY = cy;
                if (this.ui.northComp != null) {
                    int nh = this.ui.northComp.getPreferredSize().height;
                    compY -= nh;
                    compHeight += nh;
                }
                if (this.ui.southComp != null) {
                    compHeight += this.ui.southComp.getPreferredSize().height;
                }
                if (child == this.ui.leadingComp && this.ui.leadingComp != null) {
                    this.ui.layoutLeadingComponent(child, tabWidth, tabHeight, insets, tx, ty, tabPlacement);
                    continue;
                }
                if (child == this.ui.trailingComp && this.ui.trailingComp != null) {
                    this.ui.layoutTrailingComponent(child, tabWidth, tabHeight, insets, tx, ty, tw, th, tabPlacement);
                    continue;
                }
                if (child == this.ui.northComp && this.ui.northComp != null) {
                    this.ui.northComp.setBounds(cx, cy - this.ui.northComp.getPreferredSize().height, cw, this.ui.northComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.ui.southComp && this.ui.southComp != null) {
                    this.ui.southComp.setBounds(cx, cy + ch, cw, this.ui.southComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.ui.eastComp && this.ui.eastComp != null) {
                    this.ui.eastComp.setBounds(cx + cw, compY, this.ui.eastComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == this.ui.westComp && this.ui.westComp != null) {
                    this.ui.westComp.setBounds(cx - this.ui.westComp.getPreferredSize().width, compY, this.ui.westComp.getPreferredSize().width, compHeight);
                    continue;
                }
                child.setBounds(cx, cy, cw, ch);
            }
        }
        this.layoutTabComponents();
        if (shouldChangeFocus && !this.ui.requestFocusForVisibleComponent()) {
            this.ui.tabPane.requestFocus();
        }
    }

    @Override
    protected void layoutTabComponents() {
        this.ui.layoutTabComponents();
    }
}

