/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditorToggleButton
extends AbstractCellEditor
implements TableCellEditor,
SwingConstants {
    private final JToggleButton toggleButton;

    public DarkTableCellEditorToggleButton(DarkTableCellEditor delegate, JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
        toggleButton.setOpaque(true);
        toggleButton.addChangeListener(e -> delegate.setValue(toggleButton.isSelected()));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Boolean) {
            this.toggleButton.setSelected((Boolean)value);
        }
        this.toggleButton.setHorizontalAlignment(table.getComponentOrientation().isLeftToRight() ? 2 : 4);
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && isSelected && !DarkTableCellFocusBorder.isRowFocusBorder(table);
        boolean paintSelected = isSelected && !isLeadSelectionCell && !table.isEditing();
        CellUtil.setupForeground(this.toggleButton, table, paintSelected, "Table.selectionForegroundInactive");
        CellUtil.setupBackground((Component)this.toggleButton, table, paintSelected, row, "JTable.alternateRowColor", "Table.alternateRowBackground", "Table.selectionNoFocusBackground");
        return this.toggleButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.toggleButton.isSelected();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }
}

