/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DarkTableCellRenderer
extends DefaultTableCellRenderer {
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox> checkBoxRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox>(new DarkCellRendererToggleButton.CellEditorCheckBox(true));
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton> radioRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton>(new DarkCellRendererToggleButton.CellEditorRadioButton(true));

    protected static boolean isBooleanRenderingEnabled(JTable table) {
        return PropertyUtil.getBooleanProperty((JComponent)table, (String)"JTable.renderBooleanAsCheckBox");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Boolean && DarkTableCellRenderer.isBooleanRenderingEnabled(table)) {
            return this.getBooleanRenderer(table).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(table.getComponentOrientation().isLeftToRight() ? 2 : 4);
        boolean isRowFocus = DarkTableCellFocusBorder.isRowFocusBorder(table);
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && hasFocus && !isRowFocus;
        boolean paintSelected = isSelected && !isLeadSelectionCell && !table.isEditing();
        this.setupBorderStyle(table, row, column, component, isRowFocus);
        CellUtil.setupForeground(component, table, paintSelected, "Table.selectionForegroundInactive");
        CellUtil.setupBackground((Component)component, table, paintSelected, row, "JTable.alternateRowColor", "Table.alternateRowBackground", "Table.selectionNoFocusBackground");
        return component;
    }

    public void setupBorderStyle(JTable table, int row, int column, JComponent component, boolean isRowFocus) {
        if (isRowFocus && table.getSelectionModel().getLeadSelectionIndex() == row && DarkUIUtil.hasFocus(table) && !table.isEditing()) {
            component.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            component.putClientProperty("JTable.rowFocusBorder", true);
            JTableHeader header = table.getTableHeader();
            TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
            boolean forceLeft = false;
            boolean forceRight = false;
            if (draggedColumn != null) {
                int index = DarkTableUI.viewIndexForColumn(draggedColumn, table);
                forceLeft = column == index + 1 || column == index;
                forceRight = column == index - 1 || column == index;
            }
            component.putClientProperty("JTable.forcePaintRight", forceRight);
            component.putClientProperty("JTable.forcePaintLeft", forceLeft);
        } else {
            component.putClientProperty("JTable.rowFocusBorder", false);
        }
    }

    protected TableCellRenderer getBooleanRenderer(JTable table) {
        if (PropertyUtil.isPropertyEqual((JComponent)table, (String)"JTable.booleanRenderType", (Object)"radioButton")) {
            return this.radioRenderer;
        }
        return this.checkBoxRenderer;
    }
}

