/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.DarkPasswordFieldUI;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarkTextBorder
implements Border,
UIResource {
    protected final Color errorBorderColor;
    protected final Color focusErrorBorderColor = UIManager.getColor("TextField.border.focusError");
    protected final Color focusBorderColor = UIManager.getColor("TextField.border.focus");
    protected final Color borderColor;
    protected final Color inactiveBorderColor;
    protected final Color inactiveFocusBorderColor;
    protected final int borderSize;
    protected final int arc;
    protected final int searchArc;
    protected final int focusArc;
    protected final int searchFocusArc;
    protected Insets padding;
    protected final Icon showIcon;

    public DarkTextBorder() {
        this.errorBorderColor = UIManager.getColor("TextField.border.error");
        this.borderColor = UIManager.getColor("TextField.border.enabled");
        this.inactiveBorderColor = UIManager.getColor("TextField.border.disabled");
        this.inactiveFocusBorderColor = UIManager.getColor("TextField.border.disabled.focus");
        this.borderSize = UIManager.getInt("TextField.borderThickness");
        this.arc = UIManager.getInt("TextField.arc");
        this.focusArc = UIManager.getInt("TextField.focusArc");
        this.searchArc = UIManager.getInt("TextField.searchArc");
        this.searchFocusArc = UIManager.getInt("TextField.searchFocusArc");
        this.padding = UIManager.getInsets("TextField.insets");
        this.showIcon = UIManager.getIcon("PasswordField.show.icon");
        if (this.padding == null) {
            this.padding = new Insets(0, 0, 0, 0);
        }
    }

    protected static boolean hasError(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)"JTextComponent.hasError");
    }

    protected int getArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchArc : this.arc;
    }

    protected int getFocusArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchFocusArc : this.focusArc;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
        boolean focus = DarkUIUtil.hasFocus(c);
        boolean error = DarkTextBorder.hasError(c);
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        int arcSize = this.getArcSize(c);
        int focusArcSize = this.getFocusArcSize(c);
        if (error) {
            PaintUtil.paintOutlineBorder(g, width, height, focusArcSize, this.borderSize, c.hasFocus(), PaintUtil.Outline.error);
        } else if (c.hasFocus()) {
            PaintUtil.paintFocusBorder(g, width, height, focusArcSize, this.borderSize, editable);
        }
        g.setColor(this.getBorderColor(focus, error, editable, c.isEnabled()));
        PaintUtil.paintLineBorder(g, this.borderSize, this.borderSize, width - 2 * this.borderSize, height - 2 * this.borderSize, arcSize);
        g.translate(-x, -y);
        config.restore();
    }

    protected Color getBorderColor(boolean focus, boolean error, boolean editable, boolean enabled) {
        if (focus) {
            return error ? this.focusErrorBorderColor : (enabled && editable ? this.focusBorderColor : this.inactiveFocusBorderColor);
        }
        if (error) {
            return this.errorBorderColor;
        }
        return enabled && editable ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Icon right;
        Icon left;
        Insets insets = new Insets(this.borderSize + this.padding.top, this.borderSize + this.padding.left, this.borderSize + this.padding.bottom, this.borderSize + this.padding.right);
        Icon icon = left = DarkTextFieldUI.isSearchField(c) ? DarkTextFieldUI.getSearchIcon(c) : null;
        Icon icon2 = DarkPasswordFieldUI.hasShowIcon(c) ? this.showIcon : (right = DarkTextFieldUI.showClearIcon(c) ? DarkTextFieldUI.getClearIcon(false) : null);
        if (!c.getComponentOrientation().isLeftToRight()) {
            Icon tmp = right;
            right = left;
            left = tmp;
        }
        if (left != null) {
            insets.left += this.padding.left + left.getIconWidth();
        }
        if (right != null) {
            insets.right += this.padding.right + right.getIconWidth();
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

