/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import com.github.weisj.darklaf.ui.togglebutton.ButtonGroupInfo;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;

public class ToggleButtonFocusNavigationActions {
    public static void installActions(AbstractButton button) {
        if (button == null) {
            return;
        }
        button.getActionMap().put("Previous", new SelectPreviousBtn());
        button.getActionMap().put("Next", new SelectNextBtn());
        button.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
    }

    public static void uninstallActions(AbstractButton button) {
        if (button == null) {
            return;
        }
        button.getActionMap().remove("Previous");
        button.getActionMap().remove("Next");
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
    }

    protected static void selectToggleButton(ActionEvent event, boolean next) {
        Object eventSrc = event.getSource();
        if (!ButtonGroupInfo.isValidButton(eventSrc)) {
            return;
        }
        ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo((AbstractButton)eventSrc);
        btnGroupInfo.selectNewButton(next);
    }

    public static class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleButtonFocusNavigationActions.selectToggleButton(e, true);
        }
    }

    public static class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleButtonFocusNavigationActions.selectToggleButton(e, false);
        }
    }
}

