/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton.radiobutton;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonKeyHandler;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonConstants;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonFocusNavigationActions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import sun.swing.SwingUtilities2;

public class DarkRadioButtonUI
extends MetalRadioButtonUI
implements PropertyChangeListener,
ToggleButtonConstants {
    protected static final Rectangle viewRect = new Rectangle();
    protected static final Rectangle iconRect = new Rectangle();
    protected static final Rectangle textRect = new Rectangle();
    protected static Dimension size = new Dimension();
    protected RectangularShape hitArea;
    protected JToggleButton radioButton;
    protected int iconBaselineOffset;
    private Icon stateIcon;
    protected BasicButtonListener buttonListener;
    protected KeyListener keyListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.radioButton = (JToggleButton)c;
        super.installUI(c);
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.iconBaselineOffset = UIManager.getInt(this.getPropertyPrefix() + "iconBaselineOffset");
        this.hitArea = new Rectangle();
        this.installIcons();
    }

    protected void installIcons() {
        this.stateIcon = UIManager.getIcon("RadioButton.icon");
    }

    @Override
    protected void installListeners(AbstractButton button) {
        this.buttonListener = this.createButtonListener(button);
        button.addMouseListener(this.buttonListener);
        button.addMouseMotionListener(this.buttonListener);
        button.addFocusListener(this.buttonListener);
        button.addPropertyChangeListener(this.buttonListener);
        button.addChangeListener(this.buttonListener);
        this.keyListener = this.createKeyListener(button);
        button.addKeyListener(this.keyListener);
        ToggleButtonFocusNavigationActions.installActions(this.radioButton);
        button.addPropertyChangeListener(this);
    }

    protected KeyListener createKeyListener(AbstractButton button) {
        return new DarkToggleButtonKeyHandler();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.radioButton = null;
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        button.removeMouseListener(this.buttonListener);
        button.removeMouseMotionListener(this.buttonListener);
        button.removeFocusListener(this.buttonListener);
        button.removeChangeListener(this.buttonListener);
        button.removePropertyChangeListener(this.buttonListener);
        this.buttonListener = null;
        button.removeKeyListener(this.keyListener);
        this.keyListener = null;
        ToggleButtonFocusNavigationActions.uninstallActions(this.radioButton);
        button.removePropertyChangeListener(this);
    }

    @Override
    public void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        String text = this.layout(b, fm);
        this.paintBackground(c, g);
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        Icon icon = DarkRadioButtonUI.getIconBullet(c, g, b);
        if (icon != null) {
            icon.paintIcon(c, g, DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.iconRect.y);
        } else {
            Icon radioIcon = this.getStateIcon(b);
            if (radioIcon != null) {
                radioIcon.paintIcon(c, g, DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.iconRect.y);
            }
        }
        config.restore();
        if (text != null) {
            DarkRadioButtonUI.paintText(g, b, textRect, text, fm, this.getDisabledTextColor());
        }
    }

    protected void paintBackground(JComponent c, Graphics2D g) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static void paintText(Graphics2D g, AbstractButton b, Rectangle textRect, String text, FontMetrics fm, Color disabledTextColor) {
        g.setFont(b.getFont());
        g.setColor(b.isEnabled() ? b.getForeground() : disabledTextColor);
        PaintUtil.drawString(g, b, text, textRect, fm, (g2, c2, rect, t) -> {
            int textX = rect.x;
            int textY = rect.y;
            SwingUtilities2.drawStringUnderlineCharAt(b, g2, t, b.getDisplayedMnemonicIndex(), textX, textY);
        });
    }

    protected Icon getStateIcon(AbstractButton b) {
        return this.stateIcon;
    }

    public static Icon getIconBullet(JComponent c, Graphics2D g, AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        return icon;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.getStateIcon(this.radioButton);
    }

    protected String layout(AbstractButton b, FontMetrics fm) {
        Insets i = b.getInsets();
        size = b.getSize(size);
        DarkRadioButtonUI.viewRect.x = i.left;
        DarkRadioButtonUI.viewRect.y = i.top;
        DarkRadioButtonUI.viewRect.width = DarkRadioButtonUI.size.width - (i.right + DarkRadioButtonUI.viewRect.x);
        DarkRadioButtonUI.viewRect.height = DarkRadioButtonUI.size.height - (i.bottom + DarkRadioButtonUI.viewRect.y);
        DarkRadioButtonUI.iconRect.height = 0;
        DarkRadioButtonUI.iconRect.width = 0;
        DarkRadioButtonUI.iconRect.y = 0;
        DarkRadioButtonUI.iconRect.x = 0;
        DarkRadioButtonUI.textRect.height = 0;
        DarkRadioButtonUI.textRect.width = 0;
        DarkRadioButtonUI.textRect.y = 0;
        DarkRadioButtonUI.textRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        DarkRadioButtonUI.iconRect.y += this.iconBaselineOffset;
        if (ToggleButtonConstants.isTreeOrTableCellEditor(b)) {
            this.hitArea = this.calculateHitArea();
        } else {
            int x = Math.min(DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.textRect.x);
            int y = Math.min(DarkRadioButtonUI.iconRect.y, DarkRadioButtonUI.textRect.y);
            int xEnd = Math.max(DarkRadioButtonUI.iconRect.x + DarkRadioButtonUI.iconRect.width, DarkRadioButtonUI.textRect.x + DarkRadioButtonUI.textRect.width);
            int yEnd = Math.max(DarkRadioButtonUI.iconRect.y + DarkRadioButtonUI.iconRect.height, DarkRadioButtonUI.textRect.y + DarkRadioButtonUI.textRect.y);
            this.hitArea = new Rectangle(x, y, xEnd - x, yEnd - y);
        }
        return text;
    }

    protected RectangularShape calculateHitArea() {
        return new Ellipse2D.Float(Math.max(DarkRadioButtonUI.iconRect.x, 0), Math.max(DarkRadioButtonUI.iconRect.y, 0), DarkRadioButtonUI.iconRect.width, DarkRadioButtonUI.iconRect.height);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.hitArea == null || this.hitArea.isEmpty() && c instanceof JToggleButton) {
            this.layout((JToggleButton)c, c.getFontMetrics(c.getFont()));
        }
        return this.hitArea.contains(x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            this.radioButton.repaint();
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("JComponent.isTreeEditor".equals(key) || "JComponent.isTableEditor".equals(key)) {
            this.radioButton.repaint();
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("JToggleButton.clearHitArea".equals(key)) {
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("JToggleButton.iconBaselineOffset".equals(key)) {
            Object obj = evt.getNewValue();
            this.iconBaselineOffset = obj instanceof Integer ? (Integer)obj : UIManager.getInt(this.getPropertyPrefix() + "iconBaselineOffset");
        }
    }
}

