/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipUI;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class ToolTipUtil {
    public static void applyContext(JToolTip toolTip) {
        JComponent target = toolTip.getComponent();
        if (target == null) {
            return;
        }
        ToolTipContext context = ToolTipUtil.getToolTipContext(toolTip);
        if (context == null) {
            return;
        }
        context.setTarget(target);
        context.setToolTip(toolTip);
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, target);
        Point pos = ToolTipUtil.getBestPositionMatch(context, p);
        if (pos != null) {
            ToolTipUtil.moveToolTip(toolTip, pos.x, pos.y, target);
        }
    }

    protected static Point getBestPositionMatch(ToolTipContext context, Point p) {
        Alignment a;
        int n;
        if (!context.isBestFit()) {
            return context.getToolTipLocation(p, null);
        }
        Rectangle screenBounds = DarkUIUtil.getScreenBounds(context.getTarget(), p);
        Rectangle windowBounds = DarkUIUtil.getWindow(context.getTarget()).getBounds();
        Rectangle tooltipBounds = new Rectangle();
        tooltipBounds.setSize(context.getToolTip().getPreferredSize());
        Alignment original = context.getAlignment();
        Alignment originalCenter = context.getCenterAlignment();
        boolean isCenter = original == Alignment.CENTER;
        Alignment[] alignments = ToolTipUtil.getAlignments(isCenter ? originalCenter : original);
        Point pos = null;
        BiConsumer<ToolTipContext, Alignment> setter = isCenter ? ToolTipContext::setCenterAlignment : ToolTipContext::setAlignment;
        Alignment[] alignmentArray = alignments;
        int n2 = alignmentArray.length;
        for (n = 0; n < n2 && (pos = ToolTipUtil.tryPosition(a = alignmentArray[n], context, p, tooltipBounds, windowBounds, screenBounds, setter)) == null; ++n) {
        }
        if (pos == null) {
            alignmentArray = alignments;
            n2 = alignmentArray.length;
            for (n = 0; n < n2 && (pos = ToolTipUtil.tryPosition(a = alignmentArray[n], context, p, tooltipBounds, screenBounds, screenBounds, setter)) == null; ++n) {
            }
        }
        if (pos == null) {
            context.setAlignment(Alignment.CENTER);
            context.setCenterAlignment(Alignment.CENTER);
            pos = context.getFallBackPosition();
        }
        context.updateToolTip();
        context.setAlignment(original);
        context.setCenterAlignment(originalCenter);
        return pos;
    }

    protected static Alignment[] getAlignments(Alignment start) {
        return new Alignment[]{start, start.opposite(), start.clockwise().clockwise(), start.anticlockwise().anticlockwise(), start.clockwise(), start.clockwise().opposite(), start.anticlockwise(), start.anticlockwise().opposite()};
    }

    protected static Point tryPosition(Alignment a, ToolTipContext context, Point p, Rectangle tooltipBounds, Rectangle boundary, Rectangle screenBoundary, BiConsumer<ToolTipContext, Alignment> setter) {
        setter.accept(context, a);
        context.setCenterAlignment(a);
        context.updateToolTip();
        Point pos = context.getToolTipLocation(p, null);
        Point screenPos = new Point(pos.x, pos.y);
        SwingUtilities.convertPointToScreen(screenPos, context.getTarget());
        tooltipBounds.setLocation(screenPos);
        if (!ToolTipUtil.fits(tooltipBounds, boundary, screenBoundary)) {
            pos = null;
        }
        return pos;
    }

    protected static boolean fits(Rectangle toolTipBounds, Rectangle boundary, Rectangle screenBoundary) {
        if (boundary == screenBoundary) {
            return SwingUtilities.isRectangleContainingRectangle(boundary, toolTipBounds);
        }
        return SwingUtilities.isRectangleContainingRectangle(boundary, toolTipBounds) && SwingUtilities.isRectangleContainingRectangle(screenBoundary, toolTipBounds);
    }

    protected static ToolTipContext getToolTipContext(JToolTip tooltip) {
        Object context = tooltip.getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        context = tooltip.getComponent().getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        Object style = tooltip.getComponent().getClientProperty("JToolTip.style");
        if (ToolTipStyle.BALLOON.equals((Object)DarkTooltipUI.getStyle(style))) {
            return ToolTipContext.getDefaultContext();
        }
        return null;
    }

    public static void moveToolTip(JToolTip toolTip, int x, int y, JComponent target) {
        Window window = DarkUIUtil.getWindow(toolTip);
        if (window == null) {
            return;
        }
        Point targetPos = target.getLocationOnScreen();
        window.setLocation(targetPos.x + x, targetPos.y + y);
    }
}

