/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.ui.cell.CellRenderer;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import sun.awt.SunToolkit;

public final class DarkUIUtil {
    public static final IconLoader ICON_LOADER = IconLoader.get(IconLoader.class);
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();

    public static void applyInsets(Rectangle rect, Insets insets) {
        if (insets != null && rect != null) {
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.right + insets.left;
            rect.height -= insets.bottom + insets.top;
        }
    }

    public static Insets addInsets(Insets ins1, Insets ins2) {
        if (ins2 == null) {
            return ins1;
        }
        if (ins1 != null) {
            ins1.left += ins2.left;
            ins1.right += ins2.right;
            ins1.top += ins2.top;
            ins1.bottom += ins2.bottom;
            return ins1;
        }
        return null;
    }

    public static void removeInsets(Rectangle rectangle, Insets insets) {
        if (insets != null && rectangle != null) {
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
        }
    }

    public static void repaint(JComponent component) {
        if (component != null) {
            component.repaint();
        }
    }

    public static boolean hasFocus(Component c) {
        return DarkUIUtil.hasFocus(c, null);
    }

    public static boolean hasFocus(Component c, FocusEvent e) {
        if (c == null) {
            return false;
        }
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof Window) {
            return DarkUIUtil.hasFocus(c);
        }
        Component owner = null;
        if (e != null) {
            owner = e.getOppositeComponent();
        }
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    public static boolean hasFocus(Window w) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        return SwingUtilities.getWindowAncestor(owner) == w;
    }

    public static Container getUnwrappedParent(Container comp) {
        if (comp == null) {
            return null;
        }
        return SwingUtilities.getUnwrappedParent(comp);
    }

    public static Container getUnwrappedParent(Component comp) {
        if (comp == null) {
            return null;
        }
        return SwingUtilities.getUnwrappedParent(comp);
    }

    public static int getFocusAcceleratorKeyMask() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    public static Object getUIOfType(ComponentUI ui, Class<?> klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public static void doNotCancelPopupSetup(JComponent component) {
        component.putClientProperty("doNotCancelPopup", "doNotCancelPopup");
        component.putClientProperty("doNotCancelOnScroll", Boolean.TRUE);
    }

    public static boolean isInCell(Component c) {
        boolean tableHeaderCell = PropertyUtil.getBooleanProperty((Component)c, (String)"JComponent.isHeaderRenderer");
        boolean inCellRenderer = !tableHeaderCell && (DarkUIUtil.getParentOfType(CellRendererPane.class, c) != null || DarkUIUtil.getParentOfType(TableCellRenderer.class, c) != null || DarkUIUtil.getParentOfType(TreeCellRenderer.class, c) != null || DarkUIUtil.getParentOfType(CellRenderer.class, c) != null || DarkUIUtil.getParentOfType(CellEditor.class, c) != null);
        return inCellRenderer && DarkUIUtil.getParentOfType(JComboBox.class, c) == null;
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!cls.isAssignableFrom(eachParent.getClass())) continue;
            return (T)eachParent;
        }
        return null;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    public static boolean isTooltipShowing(JComponent component) {
        AbstractAction hideTipAction = (AbstractAction)component.getActionMap().get("hideTip");
        return hideTipAction.isEnabled();
    }

    public static MenuElement findEnabledChild(MenuElement[] e, MenuElement elem, boolean forward) {
        for (int i = 0; i < e.length; ++i) {
            if (e[i] != elem) continue;
            return DarkUIUtil.findEnabledChild(e, i, forward);
        }
        return null;
    }

    public static MenuElement findEnabledChild(MenuElement[] e, int fromIndex, boolean forward) {
        MenuElement result;
        if (forward) {
            result = DarkUIUtil.nextEnabledChild(e, fromIndex + 1, e.length - 1);
            if (result == null) {
                result = DarkUIUtil.nextEnabledChild(e, 0, fromIndex - 1);
            }
        } else {
            result = DarkUIUtil.previousEnabledChild(e, fromIndex - 1, 0);
            if (result == null) {
                result = DarkUIUtil.previousEnabledChild(e, e.length - 1, fromIndex + 1);
            }
        }
        return result;
    }

    private static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i >= toIndex; --i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    public static boolean isOverText(MouseEvent e, int index, JList<?> list) {
        Rectangle bounds = list.getCellBounds(index, index);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(index), index, false, false);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isOverText(JLabel label, Rectangle bounds, Point p) {
        textRect.setBounds(0, 0, 0, 0);
        iconRect.setBounds(0, 0, 0, 0);
        SwingUtilities.layoutCompoundLabel(label, label.getFontMetrics(label.getFont()), label.getText(), label.getIcon(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), bounds, iconRect, textRect, label.getIconTextGap());
        return textRect.contains(p);
    }

    public static boolean isOverText(MouseEvent e, int row, int column, JTable table) {
        Rectangle bounds = table.getCellRect(row, column, false);
        if (!bounds.contains(e.getPoint())) {
            return false;
        }
        Component cellRenderer = table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
        if (cellRenderer instanceof JLabel) {
            return DarkUIUtil.isOverText((JLabel)cellRenderer, bounds, e.getPoint());
        }
        return true;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiersEx() & 0x80) != 0;
    }

    public static void rotateRectangle(Rectangle rect) {
        int tmp = rect.x;
        rect.x = rect.y;
        rect.y = tmp;
        tmp = rect.width;
        rect.width = rect.height;
        rect.height = tmp;
    }

    public static void rotatePoint(Point p) {
        int tmp = p.x;
        p.x = p.y;
        p.y = tmp;
    }

    public static Insets getBorderInsets(JComponent comp) {
        Border border = comp.getBorder();
        if (border == null) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        return border.getBorderInsets(comp);
    }

    public static Point adjustForOrientation(Point p, int w, Component c) {
        if (!c.getComponentOrientation().isLeftToRight()) {
            p.x = c.getWidth() - p.x - w;
        }
        return p;
    }

    public static Rectangle getScreenBounds(JComponent target, Point p) {
        return DarkUIUtil.getScreenBounds(target, p.x, p.y);
    }

    public static Rectangle getScreenBounds(JComponent target, int x, int y) {
        return DarkUIUtil.getScreenBounds(target, x, y, true);
    }

    public static Rectangle getScreenBounds(JComponent target, int x, int y, boolean subtractInsets) {
        GraphicsConfiguration gc = DarkUIUtil.getDrawingGC(x, y);
        if (gc == null) {
            gc = target.getGraphicsConfiguration();
        }
        Rectangle sBounds = gc.getBounds();
        if (subtractInsets) {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            sBounds.x += screenInsets.left;
            sBounds.y += screenInsets.top;
            sBounds.width -= screenInsets.left + screenInsets.right;
            sBounds.height -= screenInsets.top + screenInsets.bottom;
        }
        return sBounds;
    }

    private static GraphicsConfiguration getDrawingGC(int x, int y) {
        GraphicsDevice[] devices;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = env.getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle rect = config.getBounds();
            if (!rect.contains(x, y)) continue;
            return config;
        }
        return null;
    }

    public static int setAltGraphMask(int modifier) {
        return modifier | 0x2000;
    }

    public static boolean isScaleChanged(PropertyChangeEvent ev) {
        return DarkUIUtil.isScaleChanged(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
    }

    public static boolean isScaleChanged(String name, Object oldValue, Object newValue) {
        if (oldValue != newValue && "graphicsConfiguration".equals(name)) {
            GraphicsConfiguration newGC = (GraphicsConfiguration)oldValue;
            GraphicsConfiguration oldGC = (GraphicsConfiguration)newValue;
            AffineTransform newTx = newGC != null ? newGC.getDefaultTransform() : null;
            AffineTransform oldTx = oldGC != null ? oldGC.getDefaultTransform() : null;
            return !Objects.equals(newTx, oldTx);
        }
        return false;
    }

    public static boolean isUndecorated(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        return false;
    }
}

