/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.components.ClosableTabComponent;
import com.github.weisj.darklaf.components.TabEvent;
import com.github.weisj.darklaf.components.TabListener;
import com.github.weisj.darklaf.components.TabPropertyChangeEvent;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ClosableTabbedPane
extends JTabbedPane {
    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (this.notifyVetoableChangeListeners(new TabPropertyChangeEvent(this, "tabOpened", null, component, index))) {
            return;
        }
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(this.indexOfComponent(component), new ClosableTabComponent(this));
        this.notifyTabListeners(new TabEvent(this, 0, "tabOpened", index));
    }

    @Override
    public void removeTabAt(int index) {
        this.checkIndex(index);
        if (this.notifyVetoableChangeListeners(new TabPropertyChangeEvent(this, "tabClosed", this.getComponentAt(index), null, index))) {
            return;
        }
        this.notifyTabListeners(new TabEvent(this, 1, "tabClosed", index));
        super.removeTabAt(index);
    }

    @Override
    public void setTabComponentAt(int index, Component component) {
        if (component instanceof ClosableTabComponent) {
            ((ClosableTabComponent)component).setTabbedPane(this);
        }
        super.setTabComponentAt(index, component);
    }

    private void checkIndex(int index) {
        int tabCount = this.getTabCount();
        if (index < 0 || index >= tabCount) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + tabCount);
        }
    }

    private boolean notifyVetoableChangeListeners(TabPropertyChangeEvent e) {
        try {
            VetoableChangeListener[] listeners;
            for (VetoableChangeListener l : listeners = this.getVetoableChangeListeners()) {
                l.vetoableChange(e);
            }
        }
        catch (PropertyVetoException ex) {
            return true;
        }
        return false;
    }

    private void notifyTabListeners(TabEvent event) {
        TabListener[] listeners = (TabListener[])this.listenerList.getListeners(TabListener.class);
        switch (event.getID()) {
            case 1: {
                for (TabListener l : listeners) {
                    l.tabClosed(event);
                }
                break;
            }
            case 0: {
                for (TabListener l : listeners) {
                    l.tabOpened(event);
                }
                break;
            }
        }
    }

    public void addTabListener(TabListener listener) {
        this.listenerList.add(TabListener.class, listener);
    }

    public void removeTabListener(TabListener listener) {
        this.listenerList.remove(TabListener.class, listener);
    }
}

