/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.text;

import com.github.weisj.darklaf.components.text.IconListener;
import com.github.weisj.darklaf.components.text.IndexListener;
import com.github.weisj.darklaf.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class NumberingPane
extends JComponent {
    public static final String KEY_EDITOR = "editorPane";
    public static final String KEY_ICONS = "icons";
    public static final String KEY_MIN_ICON_WIDTH = "minimumIconWidth";
    private JTextComponent textComponent;
    private final Map<Position, Icon> iconMap = new HashMap<Position, Icon>();
    private final Map<Position, List<IconListener>> listenerMap = new HashMap<Position, List<IconListener>>();
    private int width;

    public NumberingPane() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
        if (this.textComponent != null) {
            this.firePropertyChange(KEY_EDITOR, this.textComponent, null);
            this.firePropertyChange(KEY_EDITOR, null, this.textComponent);
        }
    }

    @Override
    public String getUIClassID() {
        return "NumberingPaneUI";
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(JTextComponent textComponent) {
        JTextComponent old = this.textComponent;
        this.textComponent = textComponent;
        this.firePropertyChange(KEY_EDITOR, old, textComponent);
    }

    public int getIconCount() {
        return this.iconMap.size();
    }

    public List<Map.Entry<Position, Icon>> getIconsInRange(int startOff, int endOff) {
        return this.iconMap.entrySet().stream().filter(e -> {
            Position pos = (Position)e.getKey();
            return pos.getOffset() >= startOff && pos.getOffset() <= endOff;
        }).collect(Collectors.toList());
    }

    public Position addIconAtLine(int lineIndex, Icon icon) throws BadLocationException {
        return this.addIconAtLine(lineIndex, icon, true);
    }

    public Position addIconAtLine(int lineIndex, Icon icon, boolean atTextStart) throws BadLocationException {
        int offset = this.textComponent.getDocument().getDefaultRootElement().getElement(lineIndex).getStartOffset();
        if (atTextStart) {
            Document doc = this.textComponent.getDocument();
            Segment txt = new Segment();
            txt.setPartialReturn(true);
            String str = doc.getText(offset, 1);
            while (StringUtil.isBlank((String)str)) {
                str = doc.getText(++offset, 1);
            }
        }
        return this.addIconAtOffset(offset, icon);
    }

    public void addIconListener(int offset, IconListener listener) throws BadLocationException {
        if (this.textComponent == null) {
            return;
        }
        this.addIconListener(this.textComponent.getDocument().createPosition(offset), listener);
    }

    public Position addIconAtOffset(int offset, Icon icon) throws BadLocationException {
        Document doc = this.textComponent.getDocument();
        Position pos = doc.createPosition(offset);
        if (icon != null) {
            this.iconMap.put(pos, icon);
        }
        this.firePropertyChange(KEY_ICONS, null, icon);
        return pos;
    }

    public void removeIconListener(int offset, IconListener listener) throws BadLocationException {
        if (this.textComponent == null) {
            return;
        }
        this.removeIconListener(this.textComponent.getDocument().createPosition(offset), listener);
    }

    public void addIconListener(Position position, IconListener listener) {
        if (!this.listenerMap.containsKey(position)) {
            this.listenerMap.put(position, new ArrayList());
        }
        List<IconListener> list = this.listenerMap.get(position);
        list.add(listener);
    }

    public void removeIconListener(Position position, IconListener listener) {
        List<IconListener> list = this.listenerMap.get(position);
        if (list != null) {
            list.remove(listener);
        }
    }

    public List<IconListener> getIconListeners(int offset) throws BadLocationException {
        if (this.textComponent == null) {
            return new ArrayList<IconListener>();
        }
        return this.getIconListeners(this.textComponent.getDocument().createPosition(offset));
    }

    public List<IconListener> getIconListeners(Position position) {
        ArrayList list = this.listenerMap.get(position);
        return list != null ? list : new ArrayList();
    }

    public List<IconListener> getIconListeners(int startOffset, int endOffset) {
        return this.listenerMap.entrySet().stream().filter(entry -> {
            Position p = (Position)entry.getKey();
            return p.getOffset() >= startOffset && p.getOffset() <= endOffset;
        }).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void addIndexListener(IndexListener listener) {
        this.listenerList.add(IndexListener.class, listener);
    }

    public void removeIndexListener(IndexListener listener) {
        this.listenerList.remove(IndexListener.class, listener);
    }

    public int getMinimumIconWidth() {
        return this.width;
    }

    public void setMinimumIconWidth(int width) {
        int old = this.width;
        this.width = Math.max(width, 0);
        this.firePropertyChange(KEY_MIN_ICON_WIDTH, old, width);
    }

    public Collection<Icon> getIcons() {
        return this.iconMap.values();
    }

    public Icon getIcon(Position position) {
        return this.iconMap.get(position);
    }

    public void removeIconAt(Position position) {
        Icon icon = this.iconMap.remove(position);
        this.firePropertyChange(KEY_ICONS, icon, icon);
    }

    public List<IconListener> getIconListeners() {
        return this.listenerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public IndexListener[] getIndexListeners() {
        return (IndexListener[])this.listenerList.getListeners(IndexListener.class);
    }
}

