/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.SystemInfo;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class InputDefaultsInitTask
implements DefaultsInitTask {
    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.initInputMapDefaults(defaults);
        InputDefaultsInitTask.patchComboBox(new MetalLookAndFeel().getDefaults(), defaults);
    }

    private void initInputMapDefaults(UIDefaults defaults) {
        InputMap buttonInputMap;
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            this.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            this.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            this.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            this.installCutCopyPasteShortcuts(tableInputMap, true);
        }
        if ((buttonInputMap = (InputMap)defaults.get("Button.focusInputMap")) != null && !SystemInfo.isMac) {
            buttonInputMap.put(KeyStroke.getKeyStroke("ENTER"), "pressed");
            buttonInputMap.put(KeyStroke.getKeyStroke("released ENTER"), "released");
        }
    }

    private void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        int mask = SystemInfo.isMac ? 256 : 128;
        inputMap.put(KeyStroke.getKeyStroke(155, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 64), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 64), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, mask), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, mask), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, mask), "cut-to-clipboard");
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }
}

