/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyActionMap;
import com.github.weisj.darklaf.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class DarkMenuItemUIBase
extends BasicMenuItemUI {
    protected int acceleratorTextOffset;
    protected boolean useEvenHeight;

    public static ComponentUI createUI(JComponent c) {
        return new DarkMenuItemUIBase();
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("doClick"));
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.useEvenHeight = !Boolean.TRUE.equals(UIManager.get(this.getPropertyPrefix() + ".evenHeight"));
        this.acceleratorTextOffset = UIManager.getInt(this.getPropertyPrefix() + ".acceleratorTextOffset");
        this.acceleratorFont = UIManager.getFont("MenuItem.font");
        this.acceleratorForeground = UIManager.getColor("MenuItem.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("MenuItem.selectionForeground");
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        LazyActionMap.installLazyActionMap(this.menuItem, DarkMenuItemUIBase.class, this.getPropertyPrefix() + ".actionMap");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.isSelected(c) ? this.selectionForeground : c.getForeground(), this.defaultTextIconGap);
    }

    protected boolean isSelected(JComponent menuItem) {
        if (!(menuItem instanceof JMenuItem)) {
            return false;
        }
        return menuItem.isEnabled() && ((JMenuItem)menuItem).isArmed();
    }

    private static void rightAlignAccText(MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        Rectangle accRect = lr.getAccRect();
        ButtonModel model = lh.getMenuItem().getModel();
        if (model.isEnabled()) {
            accRect.x = lh.getViewRect().x + lh.getViewRect().width - lh.getMenuItem().getIconTextGap() - lr.getAccRect().width;
        }
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Font holdf = g.getFont();
        Color holdc = g.getColor();
        JMenuItem mi = (JMenuItem)c;
        g.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        DarkUIUtil.applyInsets(viewRect, mi.getInsets());
        MenuItemLayoutHelper lh = this.getMenuItemLayoutHelper(checkIcon, arrowIcon, defaultTextIconGap, mi, viewRect);
        MenuItemLayoutHelper.LayoutResult lr = lh.layoutMenuItem();
        this.paintBackground(g, mi, background);
        this.paintCheckIcon(g, mi, lh, lr, holdc, foreground);
        this.paintIcon(g, mi, lh, lr, holdc);
        g.setColor(foreground);
        this.paintText(g, mi, lh, lr);
        this.paintAccText(g, mi, lh, lr);
        this.paintArrowIcon(g, mi, lh, lr, foreground);
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected MenuItemLayoutHelper getMenuItemLayoutHelper(Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, JMenuItem mi, Rectangle viewRect) {
        return new MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, this.acceleratorDelimiter, mi.getComponentOrientation().isLeftToRight(), mi.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
    }

    protected void paintCheckIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        if (lh.getCheckIcon() != null) {
            ButtonModel model = mi.getModel();
            if (model.isArmed() || mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (lh.useCheckAndArrow()) {
                lh.getCheckIcon().paintIcon(mi, g, lr.getCheckRect().x, lr.getCheckRect().y);
            }
            g.setColor(holdc);
        }
    }

    protected void paintAccText(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        DarkMenuItemUIBase.rightAlignAccText(lh, lr);
        if (!StringUtil.isBlank((String)lh.getAccText())) {
            g.setFont(lh.getAccFontMetrics().getFont());
            g.setColor(this.getAcceleratorForeground(mi));
            SwingUtilities2.drawString((JComponent)mi, g, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
        }
        config.restore();
    }

    protected Color getAcceleratorForeground(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!model.isEnabled()) {
            return this.disabledForeground;
        }
        if (model.isArmed() || b instanceof JMenu && model.isSelected()) {
            return this.acceleratorSelectionForeground;
        }
        return this.acceleratorForeground;
    }

    protected void paintIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc) {
        if (lh.getIcon() != null) {
            Icon icon;
            ButtonModel model = mi.getModel();
            if (!model.isEnabled()) {
                icon = mi.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = mi.getPressedIcon();
                if (icon == null) {
                    icon = mi.getIcon();
                }
            } else {
                icon = mi.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(mi, g, lr.getIconRect().x, lr.getIconRect().y);
                g.setColor(holdc);
            }
        }
    }

    protected void paintText(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        if (!StringUtil.isBlank((String)lh.getText())) {
            if (lh.getHtmlView() != null) {
                lh.getHtmlView().paint(g, lr.getTextRect());
            } else {
                this.paintText(g, mi, lr.getTextRect(), lh.getText());
            }
        }
        config.restore();
    }

    protected void paintArrowIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color foreground) {
        if (lh.getArrowIcon() != null) {
            ButtonModel model = mi.getModel();
            if (model.isArmed() || mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (lh.useCheckAndArrow()) {
                lh.getArrowIcon().paintIcon(mi, g, lr.getArrowRect().x, lr.getArrowRect().y);
            }
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight() + 1;
        boolean parentOpaque = menuItem.getParent().isOpaque();
        if (menuItem.isOpaque() && parentOpaque) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        }
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem mi = (JMenuItem)c;
        MenuItemLayoutHelper lh = this.getMenuItemLayoutHelper(checkIcon, arrowIcon, defaultTextIconGap, mi, MenuItemLayoutHelper.createMaxRect());
        Dimension result = new Dimension();
        result.width = lh.getLeadingGap();
        MenuItemLayoutHelper.addMaxWidth(lh.getCheckSize(), lh.getAfterCheckIconGap(), result);
        if (!lh.isTopLevelMenu() && lh.getMinTextOffset() > 0 && result.width < lh.getMinTextOffset()) {
            result.width = lh.getMinTextOffset();
        }
        MenuItemLayoutHelper.addMaxWidth(lh.getLabelSize(), this.acceleratorTextOffset, result);
        MenuItemLayoutHelper.addMaxWidth(lh.getAccSize(), this.acceleratorTextOffset, result);
        MenuItemLayoutHelper.addMaxWidth(lh.getArrowSize(), lh.getGap(), result);
        result.height = MenuItemLayoutHelper.max(lh.getCheckSize().getHeight(), lh.getLabelSize().getHeight(), lh.getAccSize().getHeight(), lh.getArrowSize().getHeight());
        Insets insets = mi.getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        if (result.height % 2 == 0 && this.useEvenHeight) {
            ++result.height;
        }
        return result;
    }

    protected static class Actions
    extends UIAction {
        protected static final String CLICK = "doClick";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }
}

