/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.listener.PopupMenuAdapter;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupMenuContainer
extends JPanel {
    private final JScrollPane scrollPane;
    private final MenuKeyListener menuKeyListener;
    private final PopupMenuListener menuListener;
    private final JPanel view = new JPanel(new BorderLayout());
    private JPopupMenu popupMenu;

    public PopupMenuContainer() {
        super(new BorderLayout());
        OverlayScrollPane overlayScrollPane = this.createScrollPane(this.view);
        this.scrollPane = overlayScrollPane.getScrollPane();
        this.add((Component)overlayScrollPane, "Center");
        this.menuKeyListener = new MenuKeyListener(){

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
                SwingUtilities.invokeLater(() -> {
                    if (PopupMenuContainer.this.popupMenu == null) {
                        return;
                    }
                    MenuElement[] path = e.getMenuSelectionManager().getSelectedPath();
                    if (path.length == 0) {
                        return;
                    }
                    Rectangle bounds = path[path.length - 1].getComponent().getBounds();
                    Rectangle r = SwingUtilities.convertRectangle(PopupMenuContainer.this.popupMenu, bounds, PopupMenuContainer.this.scrollPane);
                    PopupMenuContainer.this.scrollPane.getViewport().scrollRectToVisible(r);
                });
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }
        };
        this.menuListener = new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.onHide();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.onHide();
            }

            private void onHide() {
                if (PopupMenuContainer.this.popupMenu == null) {
                    return;
                }
                PopupMenuContainer.this.popupMenu.removePopupMenuListener(this);
                PopupMenuContainer.this.popupMenu.removeMenuKeyListener(PopupMenuContainer.this.menuKeyListener);
            }
        };
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        popupMenu.removeMenuKeyListener(this.menuKeyListener);
        popupMenu.removePopupMenuListener(this.menuListener);
        popupMenu.addMenuKeyListener(this.menuKeyListener);
        popupMenu.addPopupMenuListener(this.menuListener);
    }

    public Popup createPopup(JPopupMenu popupMenu, int posX, int posY, int maxHeight) {
        this.setPopupMenu(popupMenu);
        Dimension prefSize = popupMenu.getPreferredSize();
        if (maxHeight <= 0 || prefSize.height <= maxHeight) {
            this.setBounds(0, 0, prefSize.width, prefSize.height);
            popupMenu.setBorderPainted(true);
            return PopupFactory.getSharedInstance().getPopup(popupMenu.getInvoker(), popupMenu, posX, posY);
        }
        int increment = 1;
        if (popupMenu.getComponentCount() > 0) {
            increment = Math.max(1, popupMenu.getComponent((int)0).getPreferredSize().height / 2);
        }
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getMinimum());
        bar.setUnitIncrement(increment);
        this.view.removeAll();
        this.view.add((Component)popupMenu, "Center");
        this.setBorder(popupMenu.getBorder());
        popupMenu.setBorderPainted(false);
        this.setPreferredSize(new Dimension(prefSize.width + bar.getPreferredSize().width, maxHeight));
        return PopupFactory.getSharedInstance().getPopup(popupMenu.getInvoker(), this, posX, posY);
    }

    private OverlayScrollPane createScrollPane(JComponent content) {
        OverlayScrollPane overlayScrollPane = new OverlayScrollPane(content, 20, 31);
        JScrollBar bar = overlayScrollPane.getVerticalScrollBar();
        bar.putClientProperty("JComponent.small", Boolean.TRUE);
        DarkUIUtil.doNotCancelPopupSetup(bar);
        DarkUIUtil.doNotCancelPopupSetup(overlayScrollPane.getScrollPane());
        return overlayScrollPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }
}

