/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneScrollLayout;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DarkTabbedPaneScrollLayout
extends TabbedPaneScrollLayout {
    private final DarkTabbedPaneUI ui;

    public DarkTabbedPaneScrollLayout(DarkTabbedPaneUI ui) {
        super(ui);
        this.ui = ui;
    }

    @Override
    public void layoutContainer(Container parent) {
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int selectedIndex = this.ui.tabPane.getSelectedIndex();
        Component visibleComponent = this.ui.getVisibleComponent();
        this.calculateLayoutInfo();
        Component selectedComponent = null;
        if (selectedIndex < 0) {
            if (visibleComponent != null) {
                this.ui.setVisibleComponent(null);
            }
        } else {
            selectedComponent = this.ui.tabPane.getComponentAt(selectedIndex);
        }
        if (this.ui.tabPane.getTabCount() == 0) {
            this.ui.scrollableTabSupport.hideMoreTabsButton();
            return;
        }
        boolean shouldChangeFocus = false;
        if (selectedComponent != null) {
            Component owner;
            if (selectedComponent != visibleComponent && visibleComponent != null && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, visibleComponent)) {
                shouldChangeFocus = true;
            }
            this.ui.setVisibleComponent(selectedComponent);
        }
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        Rectangle bounds = this.ui.tabPane.getBounds();
        int numChildren = this.ui.tabPane.getComponentCount();
        if (numChildren > 0) {
            int ch;
            int cw;
            int cy;
            int cx;
            int ty;
            int tx;
            int th;
            int tw;
            switch (tabPlacement) {
                case 2: {
                    tw = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    th = bounds.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + tw + contentInsets.left + tabAreaInsets.left + tabAreaInsets.right;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    tw -= tabAreaInsets.left + tabAreaInsets.right;
                    break;
                }
                case 4: {
                    tw = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    th = bounds.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    tx = bounds.width - insets.right - tw + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    tw -= tabAreaInsets.left + tabAreaInsets.right;
                    break;
                }
                case 3: {
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    tx = insets.left + tabAreaInsets.left;
                    ty = bounds.height - insets.bottom - th + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    th -= tabAreaInsets.top + tabAreaInsets.bottom;
                    break;
                }
                default: {
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + th + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    th -= tabAreaInsets.top + tabAreaInsets.bottom;
                }
            }
            JButton moreTabs = this.ui.scrollableTabSupport.moreTabsButton;
            JComponent newTab = this.ui.scrollableTabSupport.newTabButton;
            for (int i = 0; i < numChildren; ++i) {
                Component child = this.ui.tabPane.getComponent(i);
                if (this.ui.tabScroller != null && child == this.ui.tabScroller.viewport) {
                    int vw = tw;
                    int vh = th;
                    Dimension butSize = moreTabs.isVisible() ? moreTabs.getPreferredSize() : new Dimension(0, 0);
                    boolean showNewTabButton = newTab.isVisible() && newTab.getParent() == this.ui.tabPane;
                    Dimension butSize2 = showNewTabButton ? newTab.getPreferredSize() : new Dimension(0, 0);
                    boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
                    if (tabPlacement == 2 || tabPlacement == 4) {
                        vh = th - butSize.height - butSize2.height;
                        moreTabs.setBounds(tx, ty + vh + butSize2.height, this.ui.maxTabWidth, butSize.height);
                        if (showNewTabButton) {
                            newTab.setBounds(tx, ty + vh, this.ui.maxTabWidth, butSize2.height);
                        }
                    } else if (leftToRight) {
                        vw = tw - butSize.width - butSize2.width;
                        moreTabs.setBounds(tx + vw + butSize2.width, ty, butSize.width, this.ui.maxTabHeight);
                        if (showNewTabButton) {
                            newTab.setBounds(tx + vw, ty, butSize2.width, this.ui.maxTabHeight);
                        }
                    } else {
                        vw = tw - butSize.width - butSize2.width;
                        moreTabs.setBounds(tx, ty, butSize.width, this.ui.maxTabHeight);
                        if (showNewTabButton) {
                            newTab.setBounds(tx + butSize.width, ty, butSize2.width, this.ui.maxTabHeight);
                        }
                        tx += butSize.width + butSize2.width;
                    }
                    child.setBounds(tx, ty, vw, vh);
                    continue;
                }
                int tabHeight = this.ui.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                int tabWidth = this.ui.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                int compHeight = ch;
                int compY = cy;
                if (this.ui.northComp != null) {
                    int nh = this.ui.northComp.getPreferredSize().height;
                    compY -= nh;
                    compHeight += nh;
                }
                if (this.ui.southComp != null) {
                    compHeight += this.ui.southComp.getPreferredSize().height;
                }
                if (child == this.ui.leadingComp && this.ui.leadingComp != null) {
                    this.ui.layoutLeadingComponent(child, tabWidth, tabHeight, insets, tx, ty, tabPlacement);
                    continue;
                }
                if (child == this.ui.trailingComp && this.ui.trailingComp != null) {
                    this.ui.layoutTrailingComponent(child, tabWidth, tabHeight, insets, tx, ty, tw, th, tabPlacement);
                    continue;
                }
                if (child == this.ui.northComp && this.ui.northComp != null) {
                    this.ui.northComp.setBounds(cx, cy - this.ui.northComp.getPreferredSize().height, cw, this.ui.northComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.ui.southComp && this.ui.southComp != null) {
                    this.ui.southComp.setBounds(cx, cy + ch, cw, this.ui.southComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.ui.eastComp && this.ui.eastComp != null) {
                    this.ui.eastComp.setBounds(cx + cw, compY, this.ui.eastComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == this.ui.westComp && this.ui.westComp != null) {
                    this.ui.westComp.setBounds(cx - this.ui.westComp.getPreferredSize().width, compY, this.ui.westComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == moreTabs || child == newTab) continue;
                child.setBounds(cx, cy, cw, ch);
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !this.ui.requestFocusForVisibleComponent()) {
                this.ui.tabPane.requestFocus();
            }
        }
    }

    @Override
    protected void layoutTabComponents() {
        this.ui.layoutTabComponents();
    }

    @Override
    protected Dimension calculateSize(boolean minimum) {
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        Insets insets = this.ui.tabPane.getInsets();
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int height = 0;
        int width = 0;
        int cWidth = 0;
        int cHeight = 0;
        for (int i = 0; i < this.ui.tabPane.getTabCount(); ++i) {
            Dimension size;
            Component component = this.ui.tabPane.getComponentAt(i);
            if (component == null) continue;
            Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
            if (size == null) continue;
            cHeight = Math.max(size.height, cHeight);
            cWidth = Math.max(size.width, cWidth);
        }
        width += cWidth;
        height += cHeight;
        if (this.ui.tabPane.getTabCount() > 0) {
            int tabExtent;
            if (!this.ui.isHorizontalTabPlacement()) {
                int tabHeight = this.ui.calculateTabHeight(tabPlacement, this.ui.tabPane.getSelectedIndex(), this.ui.getFontMetrics().getHeight());
                if (this.ui.scrollableTabSupport.moreTabsButton.isVisible()) {
                    tabHeight += this.ui.scrollableTabSupport.moreTabsButton.getPreferredSize().height;
                }
                height = Math.max(height, tabHeight);
                tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                width += tabExtent;
            } else {
                int tabWidth = this.ui.calculateTabWidth(tabPlacement, this.ui.tabPane.getSelectedIndex(), this.ui.getFontMetrics());
                if (this.ui.scrollableTabSupport.moreTabsButton.isVisible()) {
                    tabWidth += this.ui.scrollableTabSupport.moreTabsButton.getPreferredSize().width;
                }
                width = Math.max(width, tabWidth);
                tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                height += tabExtent;
            }
        }
        return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
    }

    @Override
    protected void calculateTabRects(int tabPlacement, int tabCount) {
        Rectangle selectedBounds;
        FontMetrics metrics = this.ui.getFontMetrics();
        Dimension size = this.ui.tabPane.getSize();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        boolean verticalTabRuns = !this.ui.isHorizontalTabPlacement();
        boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
        if (!this.ui.isHorizontalTabPlacement()) {
            this.ui.maxTabWidth = this.ui.calculateMaxTabWidth(tabPlacement);
        } else {
            this.ui.maxTabHeight = this.ui.calculateMaxTabHeight(tabPlacement);
        }
        this.ui.runCount = 0;
        this.ui.selectedRun = -1;
        if (tabCount == 0) {
            return;
        }
        this.ui.selectedRun = 0;
        this.ui.runCount = 1;
        Rectangle tabBounds = new Rectangle(0, 0, 0, 0);
        for (int i = 0; i < tabCount; ++i) {
            this.calculateRect(i, tabBounds, metrics, verticalTabRuns, tabPlacement);
        }
        JButton tabsButton = this.ui.scrollableTabSupport.moreTabsButton;
        Rectangle rectangle = selectedBounds = this.ui.tabPane.getSelectedIndex() > 0 ? new Rectangle(this.ui.rects[this.ui.tabPane.getSelectedIndex()]) : new Rectangle(0, 0, 0, 0);
        if (!verticalTabRuns) {
            int rightMargin = size.width - (insets.right + tabAreaInsets.right + insets.left + tabAreaInsets.left);
            Point p = this.getMargins(tabPlacement);
            int leftMargin = p.x;
            int returnAt = p.y;
            this.ui.currentShiftXTmp = this.ui.currentShiftX;
            this.shiftTabsX(0, leftMargin, returnAt, tabCount, false);
            if (this.ui.minVisible != this.ui.maxVisible || this.ui.minVisible != this.ui.tabPane.getSelectedIndex()) {
                selectedBounds.x += this.ui.currentShiftXTmp;
                this.shiftBoundsToVisibleX(selectedBounds, leftMargin, returnAt, tabCount);
            }
            this.restoreHiddenTabsX(leftMargin, returnAt, tabCount);
            if (this.ui.minVisible == 0 && this.ui.maxVisible == tabCount - 1 && PropertyUtil.getBooleanProperty((JComponent)this.ui.tabPane, (String)"JTabbedPane.centerTabs")) {
                this.adjustForCenterX(leftMargin, returnAt, tabCount);
            }
            if (tabsButton.isVisible() && this.ui.tabPane.getSelectedIndex() < this.ui.maxVisible) {
                int margin = returnAt + tabsButton.getPreferredSize().width;
                this.shiftTabsX(0, leftMargin, margin, tabCount, false);
                if (this.ui.minVisible > 0 || this.ui.maxVisible < tabCount - 1) {
                    this.shiftTabsX(0, leftMargin, returnAt, tabCount, false);
                }
            }
            this.adjustForDropX(leftMargin, returnAt, tabCount);
            this.layoutMoreTabsButton(tabCount);
            this.commitShiftX(this.ui.currentShiftXTmp, tabCount);
            this.ui.currentShiftX = this.ui.currentShiftXTmp;
            if (!leftToRight) {
                JComponent newTabButton;
                if (tabsButton.isVisible()) {
                    rightMargin -= tabsButton.getWidth();
                }
                if ((newTabButton = this.ui.scrollableTabSupport.newTabButton).isVisible() && newTabButton.getParent() == this.ui.tabPane) {
                    rightMargin -= newTabButton.getWidth();
                }
                for (int i = 0; i < tabCount; ++i) {
                    this.ui.rects[i].x = rightMargin - this.ui.rects[i].x - this.ui.rects[i].width;
                }
            }
            if (this.ui.scrollableTabSupport.newTabButton.isVisible()) {
                this.layoutNewTabButton(true, leftToRight, leftMargin, returnAt, tabCount);
            }
        } else {
            int bottomMargin = size.height - (insets.bottom + tabAreaInsets.bottom + insets.top + tabAreaInsets.top);
            Point p = this.getMargins(tabPlacement);
            int topMargin = p.x;
            int returnAt = p.y;
            this.ui.currentShiftYTmp = this.ui.currentShiftY;
            this.shiftTabsY(0, topMargin, returnAt, tabCount, false);
            if (this.ui.minVisible != this.ui.maxVisible || this.ui.minVisible != this.ui.tabPane.getSelectedIndex()) {
                selectedBounds.y += this.ui.currentShiftYTmp;
                this.shiftBoundsToVisibleY(selectedBounds, topMargin, returnAt, tabCount);
            }
            this.restoreHiddenTabsY(topMargin, returnAt, tabCount);
            if (this.ui.minVisible == 0 && this.ui.maxVisible == tabCount - 1 && PropertyUtil.getBooleanProperty((JComponent)this.ui.tabPane, (String)"JTabbedPane.centerTabs")) {
                this.adjustForCenterY(topMargin, returnAt, tabCount);
            }
            if (tabsButton.isVisible() && this.ui.tabPane.getSelectedIndex() < this.ui.maxVisible) {
                this.shiftTabsY(0, topMargin, bottomMargin, tabCount, false);
                if (this.ui.minVisible > 0 || this.ui.maxVisible < tabCount - 1) {
                    this.shiftTabsY(0, topMargin, returnAt, tabCount, false);
                }
            }
            this.adjustForDropY(topMargin, returnAt, tabCount);
            this.layoutMoreTabsButton(tabCount);
            this.commitShiftY(this.ui.currentShiftYTmp, tabCount);
            this.ui.currentShiftY = this.ui.currentShiftYTmp;
            if (this.ui.scrollableTabSupport.newTabButton.isVisible()) {
                this.layoutNewTabButton(false, leftToRight, topMargin, returnAt, tabCount);
            }
        }
        this.ui.tabScroller.tabPanel.setPreferredSize(tabBounds.getSize());
    }

    @Override
    protected void centerTabs(int tabPlacement, int tabCount, int returnAt) {
    }

    protected void adjustForCenterX(int leftMargin, int returnAt, int tabCount) {
        int shift = (returnAt - (this.ui.rects[tabCount - 1].x + this.ui.rects[tabCount - 1].width)) / 2;
        this.shiftTabsX(shift, 0, returnAt, tabCount - 1, true);
    }

    protected void adjustForCenterY(int topMargin, int returnAt, int tabCount) {
        int shift = (returnAt - (this.ui.rects[tabCount - 1].y + this.ui.rects[tabCount - 1].height)) / 2;
        this.shiftTabsY(shift, 0, returnAt, tabCount - 1, true);
    }

    @Override
    protected int preferredTabAreaWidth(int tabPlacement, int height) {
        return this.ui.calculateMaxTabWidth(tabPlacement);
    }

    @Override
    protected int preferredTabAreaHeight(int tabPlacement, int width) {
        return this.ui.calculateMaxTabHeight(tabPlacement);
    }

    protected Point getMargins(int tabPlacement) {
        Dimension size = this.ui.tabPane.getSize();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        JButton tabsButton = this.ui.scrollableTabSupport.moreTabsButton;
        JComponent newTabsButton = this.ui.scrollableTabSupport.newTabButton;
        if (this.ui.isHorizontalTabPlacement()) {
            int leftMargin = 0;
            int returnAt = size.width - (insets.right + tabAreaInsets.right + insets.left + tabAreaInsets.left);
            if (tabsButton.isVisible()) {
                returnAt -= tabsButton.getPreferredSize().width;
            }
            if (newTabsButton.isVisible() && newTabsButton.getParent() == this.ui.tabPane) {
                returnAt -= newTabsButton.getPreferredSize().width;
            }
            return new Point(leftMargin, returnAt);
        }
        int topMargin = 0;
        int returnAt = size.height - (insets.bottom + tabAreaInsets.bottom + insets.top + tabAreaInsets.top);
        if (tabsButton.isVisible()) {
            returnAt -= tabsButton.getPreferredSize().height;
        }
        if (newTabsButton.isVisible() && newTabsButton.getParent() == this.ui.tabPane) {
            returnAt -= newTabsButton.getPreferredSize().height;
        }
        return new Point(topMargin, returnAt);
    }

    protected void adjustForDropX(int minX, int maxX, int tabCount) {
        if (this.ui.dropSourceIndex >= 0 && this.ui.dropSourceIndex < this.ui.tabPane.getTabCount()) {
            int shift = this.ui.rects[this.ui.dropSourceIndex].width;
            this.ui.rects[this.ui.dropSourceIndex].setSize(0, 0);
            this.commitShiftX(this.ui.dropSourceIndex + 1, tabCount - 1, -1 * shift, tabCount);
        }
        if (this.ui.sourceEqualsTarget && this.ui.dropTargetIndex >= 0 && this.ui.dropTargetIndex < this.ui.tabPane.getTabCount()) {
            this.commitShiftX(this.ui.dropTargetIndex, tabCount - 1, this.ui.dropRect.width, tabCount);
        }
        this.shiftTabsX(0, minX, maxX, tabCount, false);
    }

    protected void layoutNewTabButton(boolean horizontal, boolean leftToRight, int minVal, int maxVal, int tabCount) {
        JComponent button = this.ui.scrollableTabSupport.newTabButton;
        Dimension buttonBounds = button.getPreferredSize();
        if (horizontal) {
            if (leftToRight) {
                if (this.ui.rects[tabCount - 1].x + this.ui.rects[tabCount - 1].width + buttonBounds.width > maxVal) {
                    if (button.getParent() != this.ui.tabPane) {
                        this.ui.tabPane.add(button);
                    }
                } else if (button.getParent() != this.ui.scrollableTabSupport.tabPanel) {
                    this.ui.scrollableTabSupport.tabPanel.add(button);
                }
            } else {
                int x = this.ui.rects[tabCount - 1].x;
                if (x - buttonBounds.width < minVal) {
                    if (button.getParent() != this.ui.tabPane) {
                        this.ui.tabPane.add(button);
                    }
                } else if (button.getParent() != this.ui.scrollableTabSupport.tabPanel) {
                    this.ui.scrollableTabSupport.tabPanel.add(button);
                }
            }
        } else if (this.ui.rects[tabCount - 1].y + this.ui.rects[tabCount - 1].height + buttonBounds.height > maxVal) {
            if (button.getParent() != this.ui.tabPane) {
                this.ui.tabPane.add(button);
            }
        } else if (button.getParent() != this.ui.scrollableTabSupport.tabPanel) {
            this.ui.scrollableTabSupport.tabPanel.add(button);
        }
    }

    protected void commitShiftX(int shift, int tabCount) {
        this.commitShiftX(0, tabCount - 1, shift, tabCount);
    }

    protected void commitShiftX(int low, int high, int shift, int tabCount) {
        for (int i = Math.max(low, 0); i <= Math.min(high, tabCount - 1); ++i) {
            this.ui.rects[i].x += shift;
        }
    }

    protected void commitShiftY(int shift, int tabCount) {
        this.commitShiftY(0, tabCount - 1, shift, tabCount);
    }

    protected void commitShiftY(int low, int high, int shift, int tabCount) {
        for (int i = Math.max(low, 0); i <= Math.min(high, tabCount - 1); ++i) {
            this.ui.rects[i].y += shift;
        }
    }

    protected void shiftBoundsToVisibleX(Rectangle selectedBounds, int leftMargin, int rightMargin, int tabCount) {
        if (selectedBounds.x + selectedBounds.width > rightMargin) {
            this.shiftTabsX(rightMargin - selectedBounds.x - selectedBounds.width, leftMargin, rightMargin, tabCount, true);
        } else if (selectedBounds.x < leftMargin) {
            this.shiftTabsX(-selectedBounds.x + leftMargin, leftMargin, rightMargin, tabCount, true);
        }
    }

    protected void shiftBoundsToVisibleY(Rectangle selectedBounds, int topMargin, int bottomMargin, int tabCount) {
        if (selectedBounds.y + selectedBounds.height > bottomMargin) {
            this.shiftTabsY(bottomMargin - selectedBounds.y - selectedBounds.height, topMargin, bottomMargin, tabCount, true);
        } else if (selectedBounds.y < topMargin) {
            this.shiftTabsY(-selectedBounds.y + topMargin, topMargin, bottomMargin, tabCount, true);
        }
    }

    protected void calculateRect(int i, Rectangle tabBounds, FontMetrics metrics, boolean verticalTabRuns, int tabPlacement) {
        Rectangle rect = this.ui.rects[i];
        if (!verticalTabRuns) {
            if (i > 0) {
                rect.x = this.ui.rects[i - 1].x + this.ui.rects[i - 1].width;
            } else {
                this.ui.tabRuns[0] = 0;
                this.ui.maxTabWidth = 0;
                tabBounds.height = this.ui.maxTabHeight;
                rect.x = tabBounds.x;
            }
            rect.width = this.ui.calculateTabWidth(tabPlacement, i, metrics);
            tabBounds.width = rect.x + rect.width;
            this.ui.maxTabWidth = Math.max(this.ui.maxTabWidth, rect.width);
            rect.y = tabBounds.y;
            rect.height = this.ui.maxTabHeight;
        } else {
            if (i > 0) {
                rect.y = this.ui.rects[i - 1].y + this.ui.rects[i - 1].height;
            } else {
                this.ui.tabRuns[0] = 0;
                this.ui.maxTabHeight = 0;
                tabBounds.width = this.ui.maxTabWidth;
                rect.y = tabBounds.y;
            }
            rect.height = this.ui.calculateTabHeight(tabPlacement, i, metrics.getHeight());
            tabBounds.height = rect.y + rect.height;
            this.ui.maxTabHeight = Math.max(this.ui.maxTabHeight, rect.height);
            rect.x = tabBounds.x;
            rect.width = this.ui.maxTabWidth;
        }
    }

    protected void restoreHiddenTabsX(int minX, int maxX, int tabCount) {
        if (this.ui.maxVisible < 0 || this.ui.maxVisible >= tabCount) {
            return;
        }
        int space = Math.max(maxX - this.ui.rects[this.ui.maxVisible].x - this.ui.rects[this.ui.maxVisible].width - this.ui.currentShiftXTmp, 0);
        int shift = Math.min(minX - this.ui.rects[0].x - this.ui.currentShiftXTmp, space);
        this.shiftTabsX(shift, minX, maxX, tabCount, true);
    }

    protected void restoreHiddenTabsY(int minY, int maxY, int tabCount) {
        if (this.ui.maxVisible < 0 || this.ui.maxVisible >= tabCount) {
            return;
        }
        int space = Math.max(maxY - this.ui.rects[this.ui.maxVisible].y - this.ui.rects[this.ui.maxVisible].height - this.ui.currentShiftYTmp, 0);
        int shift = Math.min(minY - this.ui.rects[0].y - this.ui.currentShiftYTmp, space);
        this.shiftTabsY(shift, minY, maxY, tabCount, true);
    }

    protected void adjustForDropY(int minY, int maxY, int tabCount) {
        if (this.ui.dropSourceIndex >= 0 && this.ui.dropSourceIndex < this.ui.tabPane.getTabCount()) {
            int shift = this.ui.rects[this.ui.dropSourceIndex].height;
            this.ui.rects[this.ui.dropSourceIndex].setSize(0, 0);
            this.commitShiftY(this.ui.dropSourceIndex + 1, tabCount - 1, -1 * shift, tabCount);
        }
        if (this.ui.sourceEqualsTarget && this.ui.dropTargetIndex >= 0 && this.ui.dropTargetIndex < this.ui.tabPane.getTabCount()) {
            this.commitShiftY(this.ui.dropTargetIndex, tabCount - 1, this.ui.dropRect.height, tabCount);
        }
        this.shiftTabsY(0, minY, maxY, tabCount, false);
    }

    public void updateVisibleRange(int tapPlacement) {
        Point p = this.getMargins(tapPlacement);
        if (this.ui.isHorizontalTabPlacement()) {
            this.shiftTabsX(0, p.x, p.y, this.ui.tabPane.getTabCount(), false);
        } else {
            this.shiftTabsY(0, p.x, p.y, this.ui.tabPane.getTabCount(), false);
        }
    }

    protected void layoutMoreTabsButton(int tabCount) {
        JButton button = this.ui.scrollableTabSupport.moreTabsButton;
        if (this.ui.minVisible > 0 || this.ui.maxVisible < tabCount - 1) {
            if (this.ui.scrollableTabSupport.moreTabsButton.isVisible()) {
                if (this.ui.minVisible != this.ui.minVisibleOld || this.ui.maxVisible != this.ui.maxVisibleOld) {
                    this.ui.scrollableTabSupport.showMoreTabsButton();
                }
            } else {
                this.ui.scrollableTabSupport.showMoreTabsButton();
            }
            this.ui.minVisibleOld = this.ui.minVisible;
            this.ui.maxVisibleOld = this.ui.maxVisible;
        } else if (button.isVisible()) {
            this.ui.scrollableTabSupport.hideMoreTabsButton();
        }
    }

    protected void shiftTabsX(int shift, int minX, int returnAt, int tabCount, boolean updateShift) {
        this.shiftTabs(shift, minX, returnAt, tabCount, updateShift, true);
    }

    protected void shiftTabsY(int shift, int minY, int returnAt, int tabCount, boolean updateShift) {
        this.shiftTabs(shift, minY, returnAt, tabCount, updateShift, false);
    }

    protected void shiftTabs(int shift, int minVal, int returnAt, int tabCount, boolean updateShift, boolean isX) {
        int i2;
        Function<Integer, Boolean> isVisible;
        int min = -1;
        int max = -1;
        int minStart = this.ui.minVisible < 0 || this.ui.minVisible >= tabCount ? 0 : this.ui.minVisible;
        int maxStart = this.ui.maxVisible < 0 || this.ui.maxVisible >= tabCount ? tabCount - 1 : this.ui.maxVisible;
        int currShift = isX ? this.ui.currentShiftXTmp + shift : this.ui.currentShiftYTmp + shift;
        Function<Integer, Boolean> function = isVisible = isX ? i -> this.isVisibleX((int)i, currShift, minVal, returnAt) : i -> this.isVisibleY((int)i, currShift, minVal, returnAt);
        if (isVisible.apply(minStart).booleanValue()) {
            min = minStart;
            i2 = minStart - 1;
            while (i2 >= 0 && isVisible.apply(i2).booleanValue()) {
                min = i2--;
            }
        } else {
            for (i2 = minStart + 1; i2 < tabCount; ++i2) {
                if (!isVisible.apply(i2).booleanValue()) continue;
                min = i2;
                break;
            }
        }
        if (min == -1) {
            min = tabCount;
        }
        if (isVisible.apply(maxStart).booleanValue()) {
            max = maxStart;
            i2 = maxStart + 1;
            while (i2 < tabCount && isVisible.apply(i2).booleanValue()) {
                max = i2++;
            }
        } else {
            for (i2 = maxStart - 1; i2 >= 0; --i2) {
                if (!isVisible.apply(i2).booleanValue()) continue;
                max = i2;
                break;
            }
        }
        this.ui.minVisible = min;
        this.ui.maxVisible = max;
        if (updateShift) {
            if (isX) {
                this.ui.currentShiftXTmp += shift;
            } else {
                this.ui.currentShiftYTmp += shift;
            }
        }
    }

    protected boolean isVisibleX(int i, int shift, int minX, int maxX) {
        int begin = this.ui.rects[i].x + shift;
        int end = begin + this.ui.rects[i].width;
        return begin < maxX && end >= minX;
    }

    protected boolean isVisibleY(int i, int shift, int minX, int maxX) {
        int begin = this.ui.rects[i].y + shift;
        int end = begin + this.ui.rects[i].height;
        return begin < maxX && end >= minX;
    }
}

