/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabAreaButton;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class MoreTabsButton
extends DarkTabAreaButton {
    protected static final String INFINITY = "\u221e";
    protected final Icon icon;
    protected final DarkTabbedPaneUI ui;
    protected final int pad;

    public MoreTabsButton(DarkTabbedPaneUI ui) {
        super(ui);
        this.ui = ui;
        this.icon = ui.getMoreTabsIcon();
        this.pad = UIManager.getInt("TabbedPane.moreTabsButton.pad");
        this.setIcon(EmptyIcon.create((int)this.icon.getIconWidth(), (int)this.icon.getIconHeight()));
        this.putClientProperty("JButton.variant", "onlyLabel");
        this.putClientProperty("JButton.square", true);
        this.setFocusable(false);
        this.setFont(this.getFont().deriveFont(8.0f));
    }

    @Override
    public Color getBackground() {
        if (this.ui == null) {
            return super.getBackground();
        }
        return this.ui.getTabAreaBackground();
    }

    @Override
    protected void paintButton(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        String label = this.getLabelString();
        int labelWidth = metrics.stringWidth(label);
        int x = (this.getWidth() - (this.icon.getIconWidth() + labelWidth + this.pad)) / 2;
        int y = (this.getHeight() - this.icon.getIconHeight()) / 2;
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        int off = 5;
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        if (tabPlacement == 1) {
            y += 2;
        } else if (tabPlacement == 3) {
            --y;
        }
        this.icon.paintIcon(this, g, x, y);
        config.restore();
        config = GraphicsUtil.setupAntialiasing(g);
        g.drawString(label, x + this.icon.getIconWidth() + this.pad, y + this.icon.getIconHeight() - off);
        config.restore();
    }

    protected String getLabelString() {
        int invisible = Math.min(this.ui.minVisible - 1 + this.ui.tabPane.getTabCount() - this.ui.maxVisible, this.ui.tabPane.getTabCount());
        return invisible >= 100 ? INFINITY : String.valueOf(invisible);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        size.width += metrics.stringWidth(this.getLabelString()) + 4 * this.pad;
        return size;
    }
}

