/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableComponent
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(EnableComponent.class);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeNode[] nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
        if (e.getActionCommand().equals("enable")) {
            log.debug("enabling currently selected gui objects");
            this.enableComponents(nodes, true);
            this.triggerChildrenRender(nodes);
        } else if (e.getActionCommand().equals("disable")) {
            log.debug("disabling currently selected gui objects");
            this.enableComponents(nodes, false);
            this.triggerChildrenRender(nodes);
        } else if (e.getActionCommand().equals("toggle")) {
            log.debug("toggling currently selected gui objects");
            this.toggleComponents(nodes);
            this.triggerChildrenRender(nodes);
        }
    }

    private void enableComponents(JMeterTreeNode[] nodes, boolean enable) {
        GuiPackage pack = GuiPackage.getInstance();
        for (JMeterTreeNode node : nodes) {
            node.setEnabled(enable);
            pack.getGui(node.getTestElement()).setEnabled(enable);
        }
    }

    private void toggleComponents(JMeterTreeNode[] nodes) {
        GuiPackage pack = GuiPackage.getInstance();
        for (JMeterTreeNode node : nodes) {
            boolean enable = !node.isEnabled();
            node.setEnabled(enable);
            pack.getGui(node.getTestElement()).setEnabled(enable);
        }
    }

    private void triggerChildrenRender(JMeterTreeNode[] nodes) {
        HashSet<TreeNode> visited = new HashSet<TreeNode>();
        ArrayDeque<JMeterTreeNode> queue = new ArrayDeque<JMeterTreeNode>(Arrays.asList(nodes));
        while (!queue.isEmpty()) {
            TreeNode next = queue.poll();
            if (!visited.add(next)) continue;
            if (next instanceof JMeterTreeNode) {
                ((JMeterTreeNode)next).nameChanged();
            }
            for (int i = 0; i < next.getChildCount(); ++i) {
                queue.add((JMeterTreeNode)next.getChildAt(i));
            }
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("enable");
        commands.add("disable");
        commands.add("toggle");
    }
}

