/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.listener.MouseClickListener;
import com.github.weisj.darklaf.listener.PopupMenuAdapter;
import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.bridge.DarkTextFieldUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.FontUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import sun.swing.SwingUtilities2;

public class DarkTextFieldUI
extends DarkTextFieldUIBridge
implements PropertyChangeListener,
MouseClickListener {
    protected static final String KEY_PREFIX = "JTextField.";
    public static final String KEY_VARIANT = "JTextField.variant";
    public static final String KEY_SHOW_CLEAR = "JTextField.showClear";
    public static final String KEY_FIND_POPUP = "JTextField.Search.FindPopup";
    public static final String VARIANT_SEARCH = "search";
    protected Icon clear;
    protected Icon clearHover;
    protected Icon search;
    protected Icon searchDisabled;
    protected Icon searchWithHistory;
    protected Icon searchWithHistoryDisabled;
    protected int arcSize;
    protected int searchArcSize;
    protected Color background;
    protected Color inactiveBackground;
    private long lastSearchEvent;
    private int buttonPad;
    private final PopupMenuListener searchPopupListener = new PopupMenuAdapter(){

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DarkTextFieldUI.this.lastSearchEvent = System.currentTimeMillis();
        }
    };
    private boolean clearHovered;
    private final MouseMotionListener mouseMotionListener = e -> this.updateCursor(e.getPoint());
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            SwingUtilities.invokeLater(() -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkTextFieldUI.this.getComponent());
                DarkTextFieldUI.this.updateCursor(p);
            });
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkTextFieldUI();
    }

    protected Icon getRightIcon(JTextComponent c) {
        return this.getClearIcon(this.clearHovered || !c.isEditable() || !c.isEnabled());
    }

    protected Icon getClearIcon(boolean clearHovered) {
        return clearHovered ? this.clearHover : this.clear;
    }

    protected Icon getLeftIcon(JTextComponent c) {
        return this.getSearchIcon(c);
    }

    protected Icon getSearchIcon(JTextComponent c) {
        boolean enabled = c.isEnabled();
        return DarkTextFieldUI.isSearchFieldWithHistoryPopup(c) ? (enabled ? this.searchWithHistory : this.searchWithHistoryDisabled) : (enabled ? this.search : this.searchDisabled);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.addIconSizes(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.addIconSizes(super.getMinimumSize(c));
    }

    protected Dimension addIconSizes(Dimension dim) {
        JTextComponent comp = this.getComponent();
        int leftPad = this.buttonPad;
        int rightPad = this.buttonPad;
        if (this.doPaintLeftIcon(comp)) {
            Icon left = this.getLeftIcon(comp);
            dim.width += left.getIconWidth() + leftPad;
            dim.height = Math.max(dim.height, left.getIconHeight());
        }
        if (this.doPaintRightIcon(comp)) {
            Icon right = this.getRightIcon(comp);
            dim.width += right.getIconWidth() + rightPad;
            dim.height = Math.max(dim.height, right.getIconHeight());
        }
        return dim;
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        return this.getVisibleEditorRect(!this.isInCell(this.editor));
    }

    protected Rectangle getVisibleEditorRect(boolean shrinkHeight) {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null && shrinkHeight) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.editor, this.editor.getFont());
            Insets ins = this.editor.getInsets();
            int height = this.editor.getHeight() - ins.top - ins.bottom;
            rect.y = ins.top + FontUtil.getCenteredFontPosition((int)height, (FontMetrics)fm);
            rect.height = fm.getHeight();
        }
        this.adjustTextRect(this.getComponent(), rect);
        return rect;
    }

    protected void adjustTextRect(JTextComponent c, Rectangle r) {
        int w;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        if (this.doPaintLeftIcon(c)) {
            w = this.getLeftIcon(c).getIconWidth() + this.buttonPad;
            if (ltr) {
                r.x += w;
            }
            r.width -= w;
        }
        if (this.doPaintRightIcon(c)) {
            w = this.getRightIcon(c).getIconWidth() + this.buttonPad;
            if (!ltr) {
                r.x += w;
            }
            r.width -= w;
        }
    }

    public static boolean isOver(Point p, Icon icon, Point e) {
        return new Rectangle(p.x, p.y, icon.getIconWidth(), icon.getIconHeight()).contains(e);
    }

    protected void updateCursor(Point p) {
        Rectangle textRect;
        ClickAction action = this.getActionUnder(p);
        boolean oldClear = this.clearHovered;
        boolean bl = this.clearHovered = action == ClickAction.RIGHT_ACTION;
        if (oldClear != this.clearHovered) {
            this.editor.repaint();
        }
        if ((textRect = this.getVisibleEditorRect(false)).contains(p)) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
        } else {
            Cursor cursor = action == ClickAction.NONE ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12);
            this.getComponent().setCursor(cursor);
        }
    }

    protected ClickAction getActionUnder(Point p) {
        JTextComponent c = this.getComponent();
        if (!c.isEnabled()) {
            return ClickAction.NONE;
        }
        if (DarkTextFieldUI.isOver(this.getRightIconPos(), this.getRightIcon(c), p) && this.doPaintRightIcon(c)) {
            return ClickAction.RIGHT_ACTION;
        }
        if (DarkTextFieldUI.isOver(this.getLeftIconPos(), this.getLeftIcon(c), p) && this.doPaintLeftIcon(c)) {
            return ClickAction.LEFT_ACTION;
        }
        return ClickAction.NONE;
    }

    private static JPopupMenu getSearchPopup(JComponent c) {
        return (JPopupMenu)PropertyUtil.getObject((JComponent)c, (String)KEY_FIND_POPUP, JPopupMenu.class);
    }

    public static boolean isSearchFieldWithHistoryPopup(JTextComponent c) {
        return DarkTextFieldUI.isSearchField(c) && DarkTextFieldUI.getSearchPopup(c) != null;
    }

    public static boolean isSearchField(Component c) {
        return PropertyUtil.isPropertyEqual((Component)c, (String)KEY_VARIANT, (Object)VARIANT_SEARCH);
    }

    public static boolean showClearIcon(JComponent c) {
        return PropertyUtil.getBooleanProperty((JComponent)c, (String)KEY_SHOW_CLEAR);
    }

    @Override
    protected void paintSafely(Graphics g) {
        GraphicsContext context = new GraphicsContext(g);
        super.paintSafely(g);
        context.restore();
        this.paintIcons(g);
    }

    protected void paintIcons(Graphics g) {
        JTextComponent c = this.getComponent();
        if (this.doPaintLeftIcon(c)) {
            this.paintLeftIcon(g);
        }
        if (this.doPaintRightIcon(c)) {
            this.paintRightIcon(g);
        }
    }

    protected boolean doPaintLeftIcon(JTextComponent c) {
        return DarkTextFieldUI.isSearchField(c);
    }

    protected boolean doPaintRightIcon(JTextComponent c) {
        return c.isEditable() && c.getText().length() > 0 && DarkTextFieldUI.showClearIcon(c);
    }

    protected void paintRightIcon(Graphics g) {
        Point p = this.getRightIconPos();
        this.getRightIcon(this.editor).paintIcon(null, g, p.x, p.y);
    }

    protected void paintLeftIcon(Graphics g) {
        Point p = this.getLeftIconPos();
        this.getLeftIcon(this.editor).paintIcon(null, g, p.x, p.y);
    }

    protected Point getLeftIconPos() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int iconSize = this.getLeftIcon(this.getComponent()).getIconWidth();
        int y = this.getIconY(r, iconSize);
        return DarkUIUtil.adjustForOrientation(new Point(r.x + this.buttonPad, y), iconSize, this.editor);
    }

    private int getIconY(Rectangle r, int iconSize) {
        int contentHeight = r.height;
        Insets margin = this.editor.getMargin();
        if (margin != null) {
            contentHeight -= margin.top + margin.bottom;
        }
        int y = r.y + (contentHeight - iconSize) / 2;
        if (margin != null) {
            y += margin.top;
        }
        return y;
    }

    protected Point getRightIconPos() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int iconSize = this.getRightIcon(this.getComponent()).getIconWidth();
        int y = this.getIconY(r, iconSize);
        return DarkUIUtil.adjustForOrientation(new Point(r.x + r.width - iconSize - this.buttonPad, y), iconSize, this.editor);
    }

    protected void showSearchPopup() {
        JPopupMenu menu;
        if ((this.lastSearchEvent == 0L || System.currentTimeMillis() - this.lastSearchEvent > 250L) && (menu = DarkTextFieldUI.getSearchPopup(this.getComponent())) != null) {
            menu.show(this.getComponent(), this.getLeftIconPos().x, this.getComponent().getHeight());
        }
    }

    @Override
    protected DarkCaret.CaretStyle getDefaultCaretStyle() {
        return DarkCaret.CaretStyle.VERTICAL_LINE_STYLE;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arcSize = UIManager.getInt("TextField.arc");
        this.searchArcSize = UIManager.getInt("TextField.searchArc");
        this.background = UIManager.getColor("TextField.background");
        this.inactiveBackground = UIManager.getColor("TextField.disabledBackground");
        this.clearHover = UIManager.getIcon("TextField.search.clearHover.icon");
        this.clear = UIManager.getIcon("TextField.search.clear.icon");
        this.searchWithHistory = UIManager.getIcon("TextField.search.searchWithHistory.icon");
        this.searchWithHistoryDisabled = UIManager.getIcon("TextField.search.searchWithHistory.disabled.icon");
        this.search = UIManager.getIcon("TextField.search.search.icon");
        this.searchDisabled = UIManager.getIcon("TextField.search.search.disabled.icon");
        this.buttonPad = UIManager.getInt("TextField.iconPad");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_FIND_POPUP.equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof JPopupMenu) {
                ((JPopupMenu)oldVal).removePopupMenuListener(this.searchPopupListener);
            }
            if (newVal instanceof JPopupMenu) {
                ((JPopupMenu)newVal).addPopupMenuListener(this.searchPopupListener);
            }
        } else if (KEY_VARIANT.equals(key)) {
            this.editor.putClientProperty(KEY_SHOW_CLEAR, DarkTextFieldUI.isSearchField(this.editor));
            this.layoutChanged();
        } else if (KEY_SHOW_CLEAR.equals(key)) {
            this.layoutChanged();
        }
    }

    protected void layoutChanged() {
        Container parent = this.editor.getParent();
        if (parent instanceof JComponent) {
            ((Component)parent).doLayout();
        }
        this.editor.repaint();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        c.addMouseListener(this);
        c.addMouseMotionListener(this.mouseMotionListener);
        c.addKeyListener(this.keyListener);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this.mouseMotionListener);
        c.removeKeyListener(this.keyListener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ClickAction actionUnder = this.getActionUnder(e.getPoint());
        if (actionUnder == ClickAction.RIGHT_ACTION) {
            this.rightActionClicked();
        } else if (actionUnder == ClickAction.LEFT_ACTION) {
            this.leftActionClicked();
        }
    }

    protected void leftActionClicked() {
        this.showSearchPopup();
    }

    protected void rightActionClicked() {
        this.getComponent().setText("");
    }

    protected static enum ClickAction {
        RIGHT_ACTION,
        LEFT_ACTION,
        NONE;

    }
}

