/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class UrlDecode
extends AbstractFunction {
    private static final String CHARSET_ENCODING = StandardCharsets.UTF_8.name();
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__urldecode";
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String decodeString = "";
        try {
            String rawString = ((CompoundVariable)this.values[0]).execute();
            decodeString = URLDecoder.decode(rawString, CHARSET_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        return decodeString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"urldecode_string"));
    }
}

