/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;

public enum EProcessorArchitecture {
    UNKNOWN(-1),
    ARCH_32(32),
    ARCH_64(64);

    private static final String SYSTEM_PROPERTY_SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    private static EProcessorArchitecture s_aInstance;
    private final int m_nBits;

    private EProcessorArchitecture(int n2) {
        if (n2 > 0 && n2 % 8 != 0) {
            throw new IllegalArgumentException("Passed bit count is illegal: " + n2);
        }
        this.m_nBits = n2;
    }

    public int getBits() {
        return this.m_nBits;
    }

    public int getBytes() {
        return this.m_nBits == -1 ? this.m_nBits : this.m_nBits / 8;
    }

    @CheckForSigned
    public static int getCurrentArchitectureBits() {
        String string = SystemProperties.getPropertyValue(SYSTEM_PROPERTY_SUN_ARCH_DATA_MODEL);
        return StringParser.parseInt(string, -1);
    }

    @Nonnull
    public static EProcessorArchitecture forBits(int n) {
        for (EProcessorArchitecture eProcessorArchitecture : EProcessorArchitecture.values()) {
            if (n != eProcessorArchitecture.getBits()) continue;
            return eProcessorArchitecture;
        }
        return UNKNOWN;
    }

    @Nonnull
    static EProcessorArchitecture getCurrentArchitecture() {
        EProcessorArchitecture eProcessorArchitecture = s_aInstance;
        if (eProcessorArchitecture == null) {
            s_aInstance = eProcessorArchitecture = EProcessorArchitecture.forBits(EProcessorArchitecture.getCurrentArchitectureBits());
        }
        return eProcessorArchitecture;
    }

    static {
        s_aInstance = null;
    }
}

