/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData;

import java.awt.Paint;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.StockChartProperties;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.ChartType;
import org.jCharts.types.StockChartDataType;

public class StockChartDataSet
implements IStockChartDataSet,
HTMLTestable {
    private ChartType chartType = ChartType.STOCK;
    private double[] high;
    private double[] low;
    private double[] open;
    private double[] close;
    private int numberOfDataSets = 2;
    private String[] legendLabels;
    private Paint[] paints;
    private StockChartProperties stockChartProperties;

    public StockChartDataSet(double[] dArray, String string, double[] dArray2, String string2, Paint paint, StockChartProperties stockChartProperties) throws ChartDataException {
        this.high = dArray;
        this.low = dArray2;
        this.legendLabels = new String[5];
        this.legendLabels[StockChartDataType.HIGH.getInt()] = string;
        this.legendLabels[StockChartDataType.LOW.getInt()] = string2;
        this.paints = new Paint[5];
        this.paints[StockChartDataType.HIGH.getInt()] = paint;
        this.paints[StockChartDataType.LOW.getInt()] = paint;
        this.stockChartProperties = stockChartProperties;
    }

    public void validate() throws ChartDataException, PropertyException {
        if (this.high == null || this.low == null) {
            throw new ChartDataException("The Hi/Low values can not be NULL.");
        }
        if (this.high.length != this.low.length) {
            throw new ChartDataException("The Hi/Low Arrays must have equal length.");
        }
        if (this.paints[StockChartDataType.HIGH.getInt()] == null) {
            throw new ChartDataException("The Hi/Low Paint implementation can not be NULL.");
        }
        this.stockChartProperties.validate(this);
    }

    public String getLegendLabel(int n) {
        return this.legendLabels[n];
    }

    public int getNumberOfLegendLabels() {
        return this.legendLabels.length;
    }

    public int getNumberOfDataItems() {
        return this.high.length;
    }

    public void setCloseValues(double[] dArray, String string, Paint paint) {
        ++this.numberOfDataSets;
        this.close = dArray;
        this.legendLabels[StockChartDataType.CLOSE.getInt()] = string;
        this.paints[StockChartDataType.CLOSE.getInt()] = paint;
    }

    public void setOpenValues(double[] dArray, String string, Paint paint) {
        ++this.numberOfDataSets;
        this.open = dArray;
        this.legendLabels[StockChartDataType.OPEN.getInt()] = string;
        this.paints[StockChartDataType.OPEN.getInt()] = paint;
    }

    public double getHighValue(int n) {
        return this.high[n];
    }

    public double getLowValue(int n) {
        return this.low[n];
    }

    public double getCloseValue(int n) {
        return this.close[n];
    }

    public boolean hasCloseValues() {
        return this.close != null;
    }

    public double getOpenValue(int n) {
        return this.open[n];
    }

    public boolean hasOpenValues() {
        return this.open != null;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public ChartTypeProperties getChartTypeProperties() {
        return this.stockChartProperties;
    }

    public int getNumberOfDataSets() {
        return this.numberOfDataSets;
    }

    public Paint getPaint(int n) {
        return this.paints[n];
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
    }
}

