/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.Javolution;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.text.CharSet;
import javolution.text.Cursor;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TypeFormat;
import javolution.util.LocalMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    private static final LocalMap CLASS_TO_FORMAT = new LocalMap();
    private final Class<T> _class;
    static final TextFormat OBJECT_FORMAT = new TextFormat(Object.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            if (RECURSION_CHECK.get().equals(Boolean.TRUE)) {
                throw new UnsupportedOperationException("Infinite recursion detected. TextFormat for Object.class uses toString() which in turn uses TextFormat.A specialized TextFormat for the class " + obj.getClass() + " should be defined");
            }
            RECURSION_CHECK.set(Boolean.TRUE);
            try {
                String str = obj.toString();
                Appendable appendable = dest.append(Javolution.j2meToCharSeq(str));
                return appendable;
            }
            finally {
                RECURSION_CHECK.set(Boolean.FALSE);
            }
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            throw new UnsupportedOperationException("TextFormat for object to be parsed is missing");
        }
    };
    private static final ThreadLocal RECURSION_CHECK = new ThreadLocal();
    static final TextFormat STRING_FORMAT = new TextFormat(String.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return dest.append(Javolution.j2meToCharSeq(obj));
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return csq.subSequence(cursor.getIndex(), csq.length()).toString();
        }
    };
    static final TextFormat BOOLEAN_FORMAT = new TextFormat(Boolean.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format((Boolean)obj, dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return TypeFormat.parseBoolean(csq, cursor) ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    static final TextFormat CHARACTER_FORMAT = new TextFormat(Character.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return dest.append(((Character)obj).charValue());
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Character(cursor.nextChar(csq));
        }
    };
    static final TextFormat BYTE_FORMAT = new TextFormat(Byte.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format(((Byte)obj).byteValue(), dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Byte(TypeFormat.parseByte(csq, 10, cursor));
        }
    };
    static final TextFormat SHORT_FORMAT = new TextFormat(Short.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format(((Short)obj).shortValue(), dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Short(TypeFormat.parseShort(csq, 10, cursor));
        }
    };
    static final TextFormat INTEGER_FORMAT = new TextFormat(Integer.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format((Integer)obj, dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Integer(TypeFormat.parseInt(csq, 10, cursor));
        }
    };
    static final TextFormat LONG_FORMAT = new TextFormat(Long.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format((Long)obj, dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Long(TypeFormat.parseLong(csq, 10, cursor));
        }
    };
    static final TextFormat FLOAT_FORMAT = new TextFormat(Float.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format(((Float)obj).floatValue(), dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Float(TypeFormat.parseFloat(csq, cursor));
        }
    };
    static final TextFormat DOUBLE_FORMAT = new TextFormat(Double.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return TypeFormat.format((Double)obj, dest);
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            return new Double(TypeFormat.parseDouble(csq, cursor));
        }
    };
    static final TextFormat CLASS_FORMAT = new TextFormat(Class.class){

        public Appendable format(Object obj, Appendable dest) throws IOException {
            return dest.append(Javolution.j2meToCharSeq(((Class)obj).getName()));
        }

        public Object parse(CharSequence csq, Cursor cursor) {
            CharSequence className = cursor.nextToken(csq, CharSet.WHITESPACES);
            if (className == null) {
                throw new IllegalArgumentException("No class name found");
            }
            Class cls = Reflection.getInstance().getClass(className);
            if (cls != null) {
                return cls;
            }
            throw new IllegalArgumentException("Class \"" + className + "\" not found (see javolution.lang.Reflection)");
        }
    };

    protected TextFormat(Class<T> cls) {
        this._class = cls;
        if (cls == null) {
            return;
        }
        if (CLASS_TO_FORMAT.containsKey(cls)) {
            throw new IllegalArgumentException("Class " + cls + " has already a default text format, " + "only local override using the TextFormat.setInstance(...)" + " method is allowed.");
        }
        CLASS_TO_FORMAT.putDefault(cls, this);
    }

    public static <T> TextFormat<T> getDefault(Class<? extends T> forClass) {
        TextFormat format = (TextFormat)CLASS_TO_FORMAT.getDefault(forClass);
        if (format != null) {
            return format;
        }
        ClassInitializer.initialize(forClass);
        return TextFormat.searchDefaultFormat(forClass);
    }

    private static TextFormat searchDefaultFormat(Class forClass) {
        TextFormat format = (TextFormat)CLASS_TO_FORMAT.getDefault(forClass);
        if (format != null) {
            return format;
        }
        Class[] interfaces = Reflection.getInstance().getInterfaces(forClass);
        int i = 0;
        while (i < interfaces.length) {
            format = (TextFormat)CLASS_TO_FORMAT.getDefault(interfaces[i]);
            if (format != null) {
                return format;
            }
            ++i;
        }
        Class parentClass = Reflection.getInstance().getSuperclass(forClass);
        return parentClass != null ? TextFormat.searchDefaultFormat(parentClass) : null;
    }

    public static <T> TextFormat<T> getInstance(Class<? extends T> forClass) {
        TextFormat format = (TextFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        ClassInitializer.initialize(forClass);
        return TextFormat.searchLocalFormat(forClass);
    }

    private static TextFormat searchLocalFormat(Class forClass) {
        TextFormat format = (TextFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        Class[] interfaces = Reflection.getInstance().getInterfaces(forClass);
        int i = 0;
        while (i < interfaces.length) {
            format = (TextFormat)CLASS_TO_FORMAT.get(interfaces[i]);
            if (format != null) {
                return format;
            }
            ++i;
        }
        Class parentClass = Reflection.getInstance().getSuperclass(forClass);
        return parentClass != null ? TextFormat.searchLocalFormat(parentClass) : null;
    }

    public static <T> void setInstance(TextFormat<T> format, Class<T> forClass) {
        CLASS_TO_FORMAT.put(forClass, format);
    }

    public final Class<T> getBoundClass() {
        return this._class;
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2) throws IllegalArgumentException;

    public final Appendable format(T obj, TextBuilder dest) {
        try {
            return this.format(obj, (Appendable)dest);
        }
        catch (IOException e) {
            throw new Error();
        }
    }

    public final Text format(T obj) {
        TextBuilder tb = TextBuilder.newInstance();
        try {
            this.format(obj, tb);
            Text text = tb.toText();
            return text;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public final T parse(CharSequence csq) throws IllegalArgumentException {
        Cursor cursor = Cursor.newInstance();
        try {
            T obj = this.parse(csq, cursor);
            if (cursor.getIndex() < csq.length()) {
                throw new IllegalArgumentException("Extraneous characters in \"" + csq + "\"");
            }
            T t = obj;
            return t;
        }
        finally {
            Cursor.recycle(cursor);
        }
    }

    public String toString() {
        Class<T> boundClass = this.getBoundClass();
        return boundClass != null ? "Default TextFormat for " + boundClass.getName() : "Dynamic TextFormat (" + this.hashCode() + ")";
    }
}

