/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastList<E>
extends FastCollection<E>
implements List<E>,
Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastList();
        }
    };
    private transient Node<E> _head = this.newNode();
    private transient Node<E> _tail = this.newNode();
    private transient FastComparator<? super E> _valueComparator = FastComparator.DEFAULT;
    private transient int _size;
    static volatile int ONE_VOLATILE = 1;
    private static final long serialVersionUID = 1L;

    public FastList() {
        this(4);
    }

    public FastList(String id) {
        this();
        new PersistentContext.Reference(id, this){

            protected void notifyChange() {
                FastList.this.clear();
                FastList.this.addAll((FastList)this.get());
            }
        };
    }

    public FastList(int capacity) {
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        Node<E> previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Node<E> newNode = this.newNode();
            ((Node)newNode)._previous = (Node)previous;
            ((Node)previous)._next = (Node)newNode;
            previous = newNode;
        }
    }

    public FastList(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> FastList<E> newInstance() {
        return (FastList)FACTORY.object();
    }

    public static void recycle(FastList instance) {
        FACTORY.recycle(instance);
    }

    @Override
    public final boolean add(E value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final E get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return (E)((Node)this.nodeAt(index))._value;
    }

    @Override
    public final E set(int index, E value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        ((Node)node)._value = value;
        return (E)previousValue;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> indexNode = this.nodeAt(index);
        Iterator<E> i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final E remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        this.delete(node);
        return (E)previousValue;
    }

    @Override
    public final int indexOf(Object value) {
        FastComparator<E> comp = this.getValueComparator();
        int index = 0;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            if (comp == FastComparator.DEFAULT ? FastList.defaultEquals(value, n._value) : comp.areEqual(value, n._value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        FastComparator<E> comp = this.getValueComparator();
        int index = this.size() - 1;
        Node n = this._tail;
        Node<E> end = this._head;
        while ((n = n._previous) != end) {
            if (comp == FastComparator.DEFAULT ? FastList.defaultEquals(value, n._value) : comp.areEqual(value, n._value)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return FastListIterator.valueOf(this, ((Node)this._head)._next, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return FastListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, ((Node)this.nodeAt(fromIndex))._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    @Override
    public final E getFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final E getLast() {
        Node node = ((Node)this._tail)._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final void addFirst(E value) {
        this.addBefore(((Node)this._head)._next, value);
    }

    @Override
    public void addLast(E value) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ((Node)this._tail)._value = value;
        this._tail = ((Node)this._tail)._next;
        this._size += ONE_VOLATILE;
    }

    @Override
    public final E removeFirst() {
        Node first = ((Node)this._head)._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        Object previousValue = first._value;
        this.delete(first);
        return (E)previousValue;
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        this._size -= ONE_VOLATILE;
        Node last = ((Node)this._tail)._previous;
        Object previousValue = last._value;
        this._tail = last;
        last._value = null;
        return (E)previousValue;
    }

    public final void addBefore(Node<E> next, E value) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        Node newNode = ((Node)this._tail)._next;
        Node node = newNode._next;
        ((Node)this._tail)._next = node;
        Node tailNext = node;
        if (tailNext != null) {
            tailNext._previous = (Node)this._tail;
        }
        Node previous = ((Node)next)._previous;
        previous._next = newNode;
        ((Node)next)._previous = newNode;
        newNode._next = (Node)next;
        newNode._previous = previous;
        newNode._value = value;
        this._size += ONE_VOLATILE;
    }

    private final Node<E> nodeAt(int index) {
        Node node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final Node<E> head() {
        return this._head;
    }

    @Override
    public final Node<E> tail() {
        return this._tail;
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((Node)record)._value;
    }

    @Override
    public final void delete(FastCollection.Record record) {
        Node node = (Node)record;
        this._size -= ONE_VOLATILE;
        node._value = null;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        Node next = ((Node)this._tail)._next;
        node._previous = (Node)this._tail;
        node._next = next;
        ((Node)this._tail)._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = ONE_VOLATILE - 1;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            n._value = null;
        }
        this._tail = ((Node)this._head)._next;
    }

    public FastList<E> setValueComparator(FastComparator<? super E> comparator) {
        this._valueComparator = comparator;
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    protected Node<E> newNode() {
        return new Node();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size;
        this._head = new Node();
        this._tail = new Node();
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        this.setValueComparator((FastComparator)stream.readObject());
        int i = size = stream.readInt();
        while (i-- != 0) {
            this.addLast(stream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getValueComparator());
        stream.writeInt(this._size);
        Node node = this._head;
        int i = this._size;
        while (i-- != 0) {
            node = node._next;
            stream.writeObject(node._value);
        }
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Node newNode0 = FastList.this.newNode();
                FastList.this._tail._next = newNode0;
                newNode0._previous = FastList.this._tail;
                Node newNode1 = FastList.this.newNode();
                newNode0._next = newNode1;
                newNode1._previous = newNode0;
                Node newNode2 = FastList.this.newNode();
                newNode1._next = newNode2;
                newNode2._previous = newNode1;
                Node newNode3 = FastList.this.newNode();
                newNode2._next = newNode3;
                newNode3._previous = newNode2;
            }
        });
    }

    @Override
    public void reset() {
        this.clear();
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private static boolean defaultEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    private static final class FastListIterator
    implements ListIterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new FastListIterator();
            }

            protected void cleanup(Object obj) {
                FastListIterator i = (FastListIterator)obj;
                i._list = null;
                i._currentNode = null;
                i._nextNode = null;
            }
        };
        private FastList _list;
        private Node _nextNode;
        private Node _currentNode;
        private int _length;
        private int _nextIndex;

        private FastListIterator() {
        }

        public static FastListIterator valueOf(FastList list, Node nextNode, int nextIndex, int size) {
            FastListIterator itr = (FastListIterator)FACTORY.object();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        public Object next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public Object previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object o) {
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        public void set(Object o) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        public void remove() {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<E>
    implements FastCollection.Record,
    Serializable {
        private Node<E> _next;
        private Node<E> _previous;
        private E _value;

        protected Node() {
        }

        public final E getValue() {
            return this._value;
        }

        @Override
        public final Node<E> getNext() {
            return this._next;
        }

        @Override
        public final Node<E> getPrevious() {
            return this._previous;
        }
    }

    private static final class SubList
    extends FastCollection
    implements List,
    Serializable {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new SubList();
            }

            protected void cleanup(Object obj) {
                SubList sl = (SubList)obj;
                sl._list = null;
                sl._head = null;
                sl._tail = null;
            }
        };
        private FastList _list;
        private Node _head;
        private Node _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(FastList list, Node head, Node tail, int size) {
            SubList subList = (SubList)FACTORY.object();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        public int size() {
            return this._size;
        }

        public FastCollection.Record head() {
            return this._head;
        }

        public FastCollection.Record tail() {
            return this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return this._list.valueOf(record);
        }

        public void delete(FastCollection.Record record) {
            this._list.delete(record);
        }

        public boolean addAll(int index, Collection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node indexNode = this.nodeAt(index);
            Iterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            return values.size() != 0;
        }

        public Object get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        public Object set(int index, Object value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node node = this.nodeAt(index);
            Object previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        public void add(int index, Object element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
        }

        public Object remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node node = this.nodeAt(index);
            Object previousValue = node._value;
            this._list.delete(node);
            return previousValue;
        }

        public int indexOf(Object value) {
            FastComparator comp = this._list.getValueComparator();
            int index = 0;
            Node n = this._head;
            Node end = this._tail;
            while ((n = n._next) != end) {
                if (comp.areEqual(value, n._value)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int lastIndexOf(Object value) {
            FastComparator comp = this.getValueComparator();
            int index = this.size() - 1;
            Node n = this._tail;
            Node end = this._head;
            while ((n = n._previous) != end) {
                if (comp.areEqual(value, n._value)) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return FastListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final Node nodeAt(int index) {
            if (index <= this._size >> 1) {
                Node node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            Node node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }
    }
}

