/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.OutputStream;
import java.io.Writer;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamWriter;
import javolution.xml.stream.XMLStreamWriterImpl;

public abstract class XMLOutputFactory {
    public static final Configurable<Class<? extends XMLOutputFactory>> CLASS = new Configurable<Class<? extends XMLOutputFactory>>(Default.class){};
    public static final String IS_REPAIRING_NAMESPACES = "javolution.xml.stream.isRepairingNamespaces";
    public static final String REPAIRING_PREFIX = "javolution.xml.stream.repairingPrefix";
    public static final String INDENTATION = "javolution.xml.stream.indentation";
    public static final String LINE_SEPARATOR = "javolution.xml.stream.lineSeparator";
    public static final String AUTOMATIC_EMPTY_ELEMENTS = "javolution.xml.stream.automaticEmptyElements";
    public static final String NO_EMPTY_ELEMENT_TAG = "javolution.xml.stream.noEmptyElementTag";
    private static final ObjectFactory XML_WRITER_FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLStreamWriterImpl();
        }

        protected void cleanup(Object obj) {
            ((XMLStreamWriterImpl)obj).reset();
        }
    };

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
    }

    protected XMLOutputFactory() {
    }

    public static XMLOutputFactory newInstance() {
        Class<? extends XMLOutputFactory> cls = CLASS.get();
        return ObjectFactory.getInstance(cls).object();
    }

    public abstract XMLStreamWriter createXMLStreamWriter(Writer var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    private static final class Default
    extends XMLOutputFactory {
        private Boolean _isRepairingNamespaces = Boolean.FALSE;
        private String _repairingPrefix = "ns";
        private Boolean _automaticEmptyElements = Boolean.FALSE;
        private Boolean _noEmptyElementTag = Boolean.FALSE;
        private String _indentation;
        private String _lineSeparator;

        private Default() {
        }

        public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
            XMLStreamWriterImpl xmlWriter = this.newWriter();
            xmlWriter.setOutput(writer);
            return xmlWriter;
        }

        public XMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
            XMLStreamWriterImpl xmlWriter = this.newWriter();
            xmlWriter.setOutput(stream);
            return xmlWriter;
        }

        public XMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
            if (encoding == null || encoding.equals("UTF-8") || encoding.equals("utf-8")) {
                return this.createXMLStreamWriter(stream);
            }
            XMLStreamWriterImpl xmlWriter = this.newWriter();
            xmlWriter.setOutput(stream, encoding);
            return xmlWriter;
        }

        private XMLStreamWriterImpl newWriter() {
            XMLStreamWriterImpl xmlWriter = (XMLStreamWriterImpl)XML_WRITER_FACTORY.object();
            xmlWriter._objectFactory = XML_WRITER_FACTORY;
            xmlWriter.setRepairingNamespaces(this._isRepairingNamespaces);
            xmlWriter.setRepairingPrefix(this._repairingPrefix);
            xmlWriter.setIndentation(this._indentation);
            xmlWriter.setLineSeparator(this._lineSeparator);
            xmlWriter.setAutomaticEmptyElements(this._automaticEmptyElements);
            xmlWriter.setNoEmptyElementTag(this._noEmptyElementTag);
            return xmlWriter;
        }

        public void setProperty(String name, Object value) throws IllegalArgumentException {
            if (name.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES)) {
                this._isRepairingNamespaces = (Boolean)value;
            } else if (name.equals(XMLOutputFactory.REPAIRING_PREFIX)) {
                this._repairingPrefix = (String)value;
            } else if (name.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS)) {
                this._automaticEmptyElements = (Boolean)value;
            } else if (name.equals(XMLOutputFactory.NO_EMPTY_ELEMENT_TAG)) {
                this._noEmptyElementTag = (Boolean)value;
            } else if (name.equals(XMLOutputFactory.INDENTATION)) {
                this._indentation = (String)value;
            } else if (name.equals(XMLOutputFactory.LINE_SEPARATOR)) {
                this._lineSeparator = (String)value;
            } else {
                throw new IllegalArgumentException("Property: " + name + " not supported");
            }
        }

        public Object getProperty(String name) throws IllegalArgumentException {
            if (name.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES)) {
                return this._isRepairingNamespaces;
            }
            if (name.equals(XMLOutputFactory.REPAIRING_PREFIX)) {
                return this._repairingPrefix;
            }
            if (name.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS)) {
                return this._automaticEmptyElements;
            }
            if (name.equals(XMLOutputFactory.NO_EMPTY_ELEMENT_TAG)) {
                return this._noEmptyElementTag;
            }
            if (name.equals(XMLOutputFactory.INDENTATION)) {
                return this._indentation;
            }
            if (name.equals(XMLOutputFactory.LINE_SEPARATOR)) {
                return this._lineSeparator;
            }
            throw new IllegalArgumentException("Property: " + name + " not supported");
        }

        public boolean isPropertySupported(String name) {
            return name.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES) || name.equals(XMLOutputFactory.REPAIRING_PREFIX) || name.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS) || name.equals(XMLOutputFactory.NO_EMPTY_ELEMENT_TAG) || name.equals(XMLOutputFactory.INDENTATION) || name.equals(XMLOutputFactory.LINE_SEPARATOR);
        }
    }
}

