/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NodeIdList
extends ArrayList<String> {
    private static final long serialVersionUID = 2585919426234285289L;

    public NodeIdList(String ... nodeIds) {
        super(Arrays.asList(nodeIds));
    }

    public NodeIdList(@Nonnull List<String> nodeIds) {
        super(nodeIds);
    }

    @Nonnull
    public static NodeIdList create(String ... nodeIds) {
        return new NodeIdList(nodeIds);
    }

    @CheckForNull
    public String getNextNodeId(@Nonnull String nodeId) throws IllegalArgumentException {
        int idx = this.indexOf(nodeId);
        if (idx < 0) {
            throw new IllegalArgumentException("The given node id is not part of this list");
        }
        if (this.size() == 1) {
            return null;
        }
        return idx == this.size() - 1 ? (String)this.get(0) : (String)this.get(idx + 1);
    }
}

