/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseClientIF;
import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseMemcachedConnection;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.config.Bucket;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.UnlockOperation;
import net.spy.memcached.transcoders.Transcoder;

public class CouchbaseClient
extends MemcachedClient
implements CouchbaseClientIF,
Reconfigurable {
    protected volatile boolean reconfiguring = false;

    public CouchbaseClient(List<URI> baseList, String bucketName, String pwd) throws IOException {
        this(new CouchbaseConnectionFactory(baseList, bucketName, pwd));
    }

    public CouchbaseClient(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException {
        this(new CouchbaseConnectionFactory(baseList, bucketName, pwd));
    }

    public CouchbaseClient(CouchbaseConnectionFactory cf) throws IOException {
        this(cf, true);
    }

    protected CouchbaseClient(CouchbaseConnectionFactory cf, boolean subscribe) throws IOException {
        super((ConnectionFactory)cf, AddrUtil.getAddresses(cf.getVBucketConfig().getServers()));
        if (subscribe) {
            cf.getConfigurationProvider().subscribe(cf.getBucketName(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        this.reconfiguring = true;
        if (bucket.isNotUpdating()) {
            this.getLogger().info((Object)"Bucket configuration is disconnected from cluster configuration updates, attempting to reconnect.");
            CouchbaseConnectionFactory cbcf = (CouchbaseConnectionFactory)this.connFactory;
            cbcf.requestConfigReconnect(cbcf.getBucketName(), this);
        }
        try {
            if (this.mconn instanceof CouchbaseConnection) {
                CouchbaseConnection cbConn = (CouchbaseConnection)this.mconn;
                cbConn.reconfigure(bucket);
            } else {
                CouchbaseMemcachedConnection cbMConn = (CouchbaseMemcachedConnection)this.mconn;
                cbMConn.reconfigure(bucket);
            }
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warn((Object)"Failed to reconfigure client, staying with previous configuration.", (Throwable)ex);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    public <T> OperationFuture<CASValue<T>> asyncGetAndLock(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout);
        GetlOperation op = this.opFact.getl(key, exp, new GetlOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                if (!status.isSuccess()) {
                    this.val = new CASValue(-1L, null);
                }
                rv.set(this.val, status);
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                assert (cas > 0L) : "CAS was less than zero:  " + cas;
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public OperationFuture<CASValue<Object>> asyncGetAndLock(String key, int exp) {
        return this.asyncGetAndLock(key, exp, (Transcoder<T>)this.transcoder);
    }

    @Override
    public <T> CASValue<T> getAndLock(String key, int exp, Transcoder<T> tc) {
        try {
            return (CASValue)this.asyncGetAndLock(key, exp, tc).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", (Throwable)e);
        }
    }

    @Override
    public CASValue<Object> getAndLock(String key, int exp) {
        return this.getAndLock(key, exp, this.transcoder);
    }

    @Override
    public <T> OperationFuture<Boolean> asyncUnlock(String key, long casId, Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout);
        UnlockOperation op = this.opFact.unlock(key, casId, new OperationCallback(){

            public void receivedStatus(OperationStatus s) {
                rv.set((Object)s.isSuccess(), s);
            }

            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    @Override
    public OperationFuture<Boolean> asyncUnlock(String key, long casId) {
        return this.asyncUnlock(key, casId, this.transcoder);
    }

    @Override
    public <T> Boolean unlock(String key, long casId, Transcoder<T> tc) {
        try {
            return (Boolean)this.asyncUnlock(key, casId, tc).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", (Throwable)e);
        }
    }

    @Override
    public Boolean unlock(String key, long casId) {
        return this.unlock(key, casId, this.transcoder);
    }

    @Override
    public int getNumVBuckets() {
        return ((CouchbaseConnectionFactory)this.connFactory).getVBucketConfig().getVbucketsCount();
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        boolean shutdownResult = super.shutdown(timeout, unit);
        CouchbaseConnectionFactory cf = (CouchbaseConnectionFactory)this.connFactory;
        cf.getConfigurationProvider().shutdown();
        return shutdownResult;
    }
}

