/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Bucket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;

public class CouchbaseMemcachedConnection
extends MemcachedConnection
implements Reconfigurable {
    protected volatile boolean reconfiguring = false;
    private final CouchbaseConnectionFactory cf;

    public CouchbaseMemcachedConnection(int bufSize, CouchbaseConnectionFactory f, List<InetSocketAddress> a, Collection<ConnectionObserver> obs, FailureMode fm, OperationFactory opfactory) throws IOException {
        super(bufSize, (ConnectionFactory)f, a, obs, fm, opfactory);
        this.cf = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        this.reconfiguring = true;
        try {
            List<String> servers = bucket.getConfig().getServers();
            HashSet<InetSocketAddress> newServerAddresses = new HashSet<InetSocketAddress>();
            ArrayList<InetSocketAddress> newServers = new ArrayList<InetSocketAddress>();
            for (String server : servers) {
                int finalColon = server.lastIndexOf(58);
                if (finalColon < 1) {
                    throw new IllegalArgumentException("Invalid server ``" + server + "'' in vbucket's server list");
                }
                String hostPart = server.substring(0, finalColon);
                String portNum = server.substring(finalColon + 1);
                InetSocketAddress address = new InetSocketAddress(hostPart, Integer.parseInt(portNum));
                newServerAddresses.add(address);
                newServers.add(address);
            }
            ArrayList<MemcachedNode> oddNodes = new ArrayList<MemcachedNode>();
            ArrayList<MemcachedNode> stayNodes = new ArrayList<MemcachedNode>();
            ArrayList<InetSocketAddress> stayServers = new ArrayList<InetSocketAddress>();
            for (MemcachedNode current : this.locator.getAll()) {
                if (newServerAddresses.contains(current.getSocketAddress())) {
                    stayNodes.add(current);
                    stayServers.add((InetSocketAddress)current.getSocketAddress());
                    continue;
                }
                oddNodes.add(current);
            }
            newServers.removeAll(stayServers);
            List newNodes = this.createConnections(newServers);
            ArrayList<MemcachedNode> mergedNodes = new ArrayList<MemcachedNode>();
            mergedNodes.addAll(stayNodes);
            mergedNodes.addAll(newNodes);
            if (this.locator instanceof VBucketNodeLocator) {
                ((VBucketNodeLocator)this.locator).updateLocator(mergedNodes, bucket.getConfig());
            } else {
                for (MemcachedNode node : mergedNodes) {
                    if (node.isActive()) continue;
                    this.queueReconnect(node);
                }
                this.locator.updateLocator(mergedNodes);
            }
            this.nodesToShutdown.addAll(oddNodes);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Connection reconfiguration failed", (Throwable)e);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    public void run() {
        while (this.running) {
            if (this.reconfiguring) continue;
            try {
                this.handleIO();
            }
            catch (IOException e) {
                this.logRunException(e);
            }
            catch (CancelledKeyException e) {
                this.logRunException(e);
            }
            catch (ClosedSelectorException e) {
                this.logRunException(e);
            }
            catch (IllegalStateException e) {
                this.logRunException(e);
            }
        }
        this.getLogger().info((Object)"Shut down Couchbase client");
    }

    private void logRunException(Exception e) {
        if (this.shutDown) {
            this.getLogger().debug((Object)"Exception occurred during shutdown", (Throwable)e);
        } else {
            this.getLogger().warn((Object)"Problem handling Couchbase IO", (Throwable)e);
        }
    }
}

