/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import net.spy.memcached.TapAck;
import net.spy.memcached.TapConnectionProvider;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.ResponseMessage;
import net.spy.memcached.tapmessage.TapOpcode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapClient {
    private boolean vBucketAware;
    private BlockingQueue<Object> rqueue;
    private HashMap<Operation, TapConnectionProvider> omap;
    private List<InetSocketAddress> addrs;
    private List<URI> baseList;
    private String bucketName;
    private String usr;
    private String pwd;
    private long messagesRead;

    public TapClient(InetSocketAddress ... ia) {
        this(Arrays.asList(ia));
    }

    public TapClient(List<InetSocketAddress> addrs) {
        this.rqueue = new LinkedBlockingQueue<Object>();
        this.omap = new HashMap();
        this.vBucketAware = false;
        this.addrs = addrs;
        this.baseList = null;
        this.bucketName = null;
        this.usr = null;
        this.pwd = null;
        this.messagesRead = 0L;
    }

    public TapClient(List<URI> baseList, String bucketName, String usr, String pwd) {
        for (URI bu : baseList) {
            if (bu.isAbsolute()) continue;
            throw new IllegalArgumentException("The base URI must be absolute");
        }
        this.rqueue = new LinkedBlockingQueue<Object>();
        this.omap = new HashMap();
        this.vBucketAware = true;
        this.addrs = null;
        this.baseList = baseList;
        this.bucketName = bucketName;
        this.usr = usr;
        this.pwd = pwd;
        this.messagesRead = 0L;
    }

    public ResponseMessage getNextMessage() {
        return this.getNextMessage(1L, TimeUnit.SECONDS);
    }

    public ResponseMessage getNextMessage(long time, TimeUnit timeunit) {
        try {
            Object m = this.rqueue.poll(time, timeunit);
            if (m == null) {
                return null;
            }
            if (m instanceof ResponseMessage) {
                return (ResponseMessage)m;
            }
            if (m instanceof TapAck) {
                TapAck ack = (TapAck)m;
                this.tapAck(ack.getConn(), ack.getOpcode(), ack.getOpaque(), ack.getCallback());
                return null;
            }
            throw new RuntimeException("Unexpected tap message type");
        }
        catch (InterruptedException e) {
            this.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreMessages() {
        if (!this.rqueue.isEmpty()) {
            return true;
        }
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (Operation op : this.omap.keySet()) {
                if (!op.getState().equals((Object)OperationState.COMPLETE) && !op.isCancelled() && !op.hasErrored()) continue;
                this.omap.get(op).shutdown();
                this.omap.remove(op);
            }
            if (this.omap.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation tapCustom(String id, RequestMessage message) throws ConfigurationException, IOException {
        final TapConnectionProvider conn = this.vBucketAware ? new TapConnectionProvider(this.baseList, this.bucketName, this.usr, this.pwd) : new TapConnectionProvider(this.addrs);
        final CountDownLatch latch = new CountDownLatch(1);
        TapOperation op = conn.opFact.tapCustom(id, message, new TapOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
            }

            public void gotData(ResponseMessage tapMessage) {
                TapClient.this.rqueue.add(tapMessage);
                TapClient.this.messagesRead++;
            }

            public void gotAck(TapOpcode opcode, int opaque) {
                TapClient.this.rqueue.add(new TapAck(conn, opcode, opaque, this));
            }

            public void complete() {
                latch.countDown();
            }
        });
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(op, conn);
        }
        conn.addOp(op);
        return op;
    }

    public Operation tapBackfill(String id, int runTime, TimeUnit timeunit) throws IOException, ConfigurationException {
        return this.tapBackfill(id, -1L, runTime, timeunit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation tapBackfill(String id, long date, final int runTime, final TimeUnit timeunit) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = this.vBucketAware ? new TapConnectionProvider(this.baseList, this.bucketName, this.usr, this.pwd) : new TapConnectionProvider(this.addrs);
        final CountDownLatch latch = new CountDownLatch(1);
        final TapOperation op = conn.opFact.tapBackfill(id, date, new TapOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
            }

            public void gotData(ResponseMessage tapMessage) {
                TapClient.this.rqueue.add(tapMessage);
                TapClient.this.messagesRead++;
            }

            public void gotAck(TapOpcode opcode, int opaque) {
                TapClient.this.rqueue.add(new TapAck(conn, opcode, opaque, this));
            }

            public void complete() {
                latch.countDown();
            }
        });
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(op, conn);
        }
        conn.addOp(op);
        if (runTime > 0) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(runTime, timeunit));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    conn.shutdown();
                    HashMap hashMap = TapClient.this.omap;
                    synchronized (hashMap) {
                        TapClient.this.omap.remove(op);
                    }
                }
            };
            new Thread(r).start();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation tapDump(String id) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = this.vBucketAware ? new TapConnectionProvider(this.baseList, this.bucketName, this.usr, this.pwd) : new TapConnectionProvider(this.addrs);
        final CountDownLatch latch = new CountDownLatch(1);
        TapOperation op = conn.opFact.tapDump(id, new TapOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
            }

            public void gotData(ResponseMessage tapMessage) {
                TapClient.this.rqueue.add(tapMessage);
                TapClient.this.messagesRead++;
            }

            public void gotAck(TapOpcode opcode, int opaque) {
                TapClient.this.rqueue.add(new TapAck(conn, opcode, opaque, this));
            }

            public void complete() {
                latch.countDown();
            }
        });
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(op, conn);
        }
        conn.addOp(op);
        return op;
    }

    private void tapAck(TapConnectionProvider conn, TapOpcode opcode, int opaque, OperationCallback cb) {
        TapOperation op = conn.opFact.tapAck(opcode, opaque, cb);
        conn.addOp(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (Map.Entry<Operation, TapConnectionProvider> me : this.omap.entrySet()) {
                me.getValue().shutdown();
            }
        }
    }

    public long getMessagesRead() {
        return this.messagesRead;
    }
}

