/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.UUID;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.protocol.binary.TapOperationImpl;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.TapFlag;
import net.spy.memcached.tapmessage.TapMagic;
import net.spy.memcached.tapmessage.TapOpcode;

public class TapBackfillOperationImpl
extends TapOperationImpl
implements TapOperation {
    private final String id;
    private final long date;

    TapBackfillOperationImpl(String id, long date, OperationCallback cb) {
        super(cb);
        this.id = id;
        this.date = date;
    }

    public void initialize() {
        RequestMessage message = new RequestMessage();
        message.setMagic(TapMagic.PROTOCOL_BINARY_REQ);
        message.setOpcode(TapOpcode.REQUEST);
        message.setFlags(TapFlag.BACKFILL);
        message.setFlags(TapFlag.SUPPORT_ACK);
        if (this.id != null) {
            message.setName(this.id);
        } else {
            message.setName(UUID.randomUUID().toString());
        }
        message.setBackfill(this.date);
        this.setBuffer(message.getBytes());
    }

    public void streamClosed(OperationState state) {
        this.transitionState(state);
    }

    public String toString() {
        return "Cmd: tap dump Flags: backfill,ack";
    }
}

