/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.reflectasm;

import com.esotericsoftware.reflectasm.AccessClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class FieldAccess {
    private Field[] fields;

    public static FieldAccess get(Class type) {
        AccessClassLoader loader = new AccessClassLoader(type.getClassLoader());
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers)) continue;
                fields.add(field);
            }
        }
        String className = type.getName();
        String accessClassName = className + "FieldAccess";
        Class<?> accessClass = null;
        try {
            accessClass = loader.loadClass(accessClassName);
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (accessClass == null) {
            Type fieldType;
            Field field;
            int i;
            int n;
            int n2;
            Label[] labels;
            String accessClassNameInternal = accessClassName.replace('.', '/');
            String classNameInternal = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(0);
            cw.visit(196653, 1, accessClassNameInternal, null, "com/esotericsoftware/reflectasm/FieldAccess", null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "com/esotericsoftware/reflectasm/FieldAccess", "<init>", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(21, 2);
            if (!fields.isEmpty()) {
                labels = new Label[fields.size()];
                n2 = labels.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    labels[i2] = new Label();
                }
                Label defaultLabel = new Label();
                mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
                n = labels.length;
                for (i = 0; i < n; ++i) {
                    field = (Field)fields.get(i);
                    fieldType = Type.getType(field.getType());
                    mv.visitLabel(labels[i]);
                    mv.visitFrame(3, 0, null, 0, null);
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, classNameInternal);
                    mv.visitVarInsn(25, 3);
                    switch (fieldType.getSort()) {
                        case 1: {
                            mv.visitTypeInsn(192, "java/lang/Boolean");
                            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 3: {
                            mv.visitTypeInsn(192, "java/lang/Byte");
                            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 2: {
                            mv.visitTypeInsn(192, "java/lang/Character");
                            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 4: {
                            mv.visitTypeInsn(192, "java/lang/Short");
                            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 5: {
                            mv.visitTypeInsn(192, "java/lang/Integer");
                            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 6: {
                            mv.visitTypeInsn(192, "java/lang/Float");
                            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 7: {
                            mv.visitTypeInsn(192, "java/lang/Long");
                            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 8: {
                            mv.visitTypeInsn(192, "java/lang/Double");
                            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                            break;
                        }
                        case 9: {
                            mv.visitTypeInsn(192, fieldType.getDescriptor());
                            break;
                        }
                        case 10: {
                            mv.visitTypeInsn(192, fieldType.getInternalName());
                        }
                    }
                    mv.visitFieldInsn(181, classNameInternal, field.getName(), fieldType.getDescriptor());
                    mv.visitInsn(177);
                }
                mv.visitLabel(defaultLabel);
                mv.visitFrame(3, 0, null, 0, null);
            }
            mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Field not found: ");
            mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitMaxs(6, 5);
            mv.visitEnd();
            mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(21, 2);
            if (!fields.isEmpty()) {
                labels = new Label[fields.size()];
                n2 = labels.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    labels[i3] = new Label();
                }
                Label defaultLabel = new Label();
                mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
                n = labels.length;
                for (i = 0; i < n; ++i) {
                    field = (Field)fields.get(i);
                    mv.visitLabel(labels[i]);
                    mv.visitFrame(3, 0, null, 0, null);
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, classNameInternal);
                    mv.visitFieldInsn(180, classNameInternal, field.getName(), Type.getDescriptor(field.getType()));
                    fieldType = Type.getType(field.getType());
                    switch (fieldType.getSort()) {
                        case 1: {
                            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                            break;
                        }
                        case 3: {
                            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                            break;
                        }
                        case 2: {
                            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                            break;
                        }
                        case 4: {
                            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                            break;
                        }
                        case 5: {
                            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                            break;
                        }
                        case 6: {
                            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                            break;
                        }
                        case 7: {
                            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                            break;
                        }
                        case 8: {
                            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                        }
                    }
                    mv.visitInsn(176);
                }
                mv.visitLabel(defaultLabel);
                mv.visitFrame(3, 0, null, 0, null);
            }
            mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Field not found: ");
            mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitMaxs(6, 4);
            mv.visitEnd();
            cw.visitEnd();
            byte[] data = cw.toByteArray();
            accessClass = loader.defineClass(accessClassName, data);
        }
        try {
            FieldAccess access = (FieldAccess)accessClass.newInstance();
            access.fields = fields.toArray(new Field[fields.size()]);
            return access;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing field access class: " + accessClassName, ex);
        }
    }

    public abstract void set(Object var1, int var2, Object var3);

    public abstract Object get(Object var1, int var2);

    public int getIndex(String fieldName) {
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            Field field = this.fields[i];
            if (!field.getName().equals(fieldName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find public field: " + fieldName);
    }

    public void set(Object object, String fieldName, Object value) {
        this.set(object, this.getIndex(fieldName), value);
    }

    public Object get(Object object, String fieldName) {
        return this.get(object, this.getIndex(fieldName));
    }
}

