/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.SocketFactory;

public class ManagedSocketFactory
implements SocketFactory {
    private final SocketBindingManager manager;

    public ManagedSocketFactory(SocketBindingManager manager) {
        this.manager = manager;
    }

    public Socket createSocket(String name) throws IOException {
        return this.manager.getSocketFactory().createSocket(name);
    }

    public Socket createSocket(String name, String host, int port) throws IOException {
        return this.manager.getSocketFactory().createSocket(name, host, port);
    }

    public Socket createSocket(String name, InetAddress address, int port) throws IOException {
        return this.manager.getSocketFactory().createSocket(name, address, port);
    }

    public Socket createSocket(String name, String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.manager.getSocketFactory().createSocket(name, host, port, localHost, localPort);
    }

    public Socket createSocket(String name, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.manager.getSocketFactory().createSocket(name, address, port, localAddress, localPort);
    }

    public ServerSocket createServerSocket(String name) throws IOException {
        return this.manager.getServerSocketFactory().createServerSocket(name);
    }

    public ServerSocket createServerSocket(String name, int port) throws IOException {
        return this.manager.getServerSocketFactory().createServerSocket(name, port);
    }

    public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
        return this.manager.getServerSocketFactory().createServerSocket(name, port, backlog);
    }

    public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.manager.getServerSocketFactory().createServerSocket(name, port, backlog, ifAddress);
    }

    public DatagramSocket createDatagramSocket(String name) throws SocketException {
        return this.createDatagramSocket(name, 0);
    }

    public DatagramSocket createDatagramSocket(String name, SocketAddress address) throws SocketException {
        return address != null ? this.manager.createDatagramSocket(name, address) : this.manager.createDatagramSocket(name);
    }

    public DatagramSocket createDatagramSocket(String name, int port) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(port));
    }

    public DatagramSocket createDatagramSocket(String name, int port, InetAddress address) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(address, port));
    }

    public MulticastSocket createMulticastSocket(String name) throws IOException {
        return this.createMulticastSocket(name, 0);
    }

    public MulticastSocket createMulticastSocket(String name, int port) throws IOException {
        return this.createMulticastSocket(name, new InetSocketAddress(port));
    }

    public MulticastSocket createMulticastSocket(String name, SocketAddress address) throws IOException {
        return address != null ? this.manager.createMulticastSocket(name, address) : this.manager.createMulticastSocket(name);
    }

    public void close(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public void close(ServerSocket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public void close(DatagramSocket socket) {
        if (socket != null) {
            socket.close();
        }
    }

    public Map<Object, String> getSockets() {
        return null;
    }
}

