/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CredentialSourceDependency;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.auth.AuthToken;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public abstract class AuthTokenBuilder<T extends AuthToken>
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<T>,
Function<String, T> {
    private volatile ValueDependency<CredentialSource> sharedSecretSource;

    public AuthTokenBuilder(PathAddress address) {
        super((Capability)AuthTokenResourceDefinition.Capability.AUTH_TOKEN, address);
    }

    public Builder<T> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.sharedSecretSource = new CredentialSourceDependency(context, (Attribute)AuthTokenResourceDefinition.Attribute.SHARED_SECRET, model);
        return this;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        Function<CredentialSource, String> sharedSecret = sharedSecretSource -> {
            try {
                PasswordCredential credential = (PasswordCredential)sharedSecretSource.getCredential(PasswordCredential.class);
                ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
                return String.valueOf(password.getPassword());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        };
        return this.sharedSecretSource.register(target.addService(this.getServiceName(), (Service)new MappedValueService(sharedSecret.andThen(this), this.sharedSecretSource)));
    }
}

