/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManagerStatistics;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSessionManager
implements UndertowSessionManager {
    private final String deploymentName;
    private final SessionListeners listeners;
    private final SessionManager<LocalSessionContext, Batch> manager;
    private final RecordableSessionManagerStatistics statistics;
    private final StampedLock lifecycleLock = new StampedLock();
    private OptionalLong lifecycleStamp = OptionalLong.empty();

    public DistributableSessionManager(String deploymentName, SessionManager<LocalSessionContext, Batch> manager, SessionListeners listeners, RecordableSessionManagerStatistics statistics) {
        this.deploymentName = deploymentName;
        this.manager = manager;
        this.listeners = listeners;
        this.statistics = statistics;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.listeners;
    }

    @Override
    public SessionManager<LocalSessionContext, Batch> getSessionManager() {
        return this.manager;
    }

    public synchronized void start() {
        this.lifecycleStamp.ifPresent(stamp -> this.lifecycleLock.unlock(stamp));
        this.manager.start();
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    public synchronized void stop() {
        if (!this.lifecycleStamp.isPresent()) {
            try {
                this.lifecycleStamp = OptionalLong.of(this.lifecycleLock.writeLockInterruptibly());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.manager.stop();
        }
    }

    private Runnable getSessionCloseTask() {
        long stamp = this.lifecycleLock.tryReadLock();
        if (stamp == 0L) {
            throw UndertowClusteringLogger.ROOT_LOGGER.sessionManagerStopped();
        }
        return () -> this.lifecycleLock.unlock(stamp);
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String requestedId = config.findSessionId(exchange);
        String id = requestedId == null ? (String)this.manager.createIdentifier() : requestedId;
        Runnable closeTask = this.getSessionCloseTask();
        boolean close = true;
        try {
            Batcher batcher = this.manager.getBatcher();
            Batch batch = batcher.createBatch();
            try {
                Session session = this.manager.createSession(id);
                if (session == null) {
                    throw UndertowClusteringLogger.ROOT_LOGGER.sessionAlreadyExists(id);
                }
                if (requestedId == null) {
                    config.setSessionId(exchange, id);
                }
                DistributableSession result = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch(), closeTask);
                this.listeners.sessionCreated((io.undertow.server.session.Session)result, exchange);
                if (this.statistics != null) {
                    this.statistics.record(result);
                }
                close = false;
                DistributableSession distributableSession = result;
                return distributableSession;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                batch.close();
                throw e;
            }
        }
        finally {
            if (close) {
                closeTask.run();
            }
        }
    }

    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = config.findSessionId(exchange);
        if (id == null) {
            return null;
        }
        try {
            Base64.getUrlDecoder().decode(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Runnable closeTask = this.getSessionCloseTask();
        boolean close = true;
        try {
            Session session;
            Batcher batcher;
            block12: {
                batcher = this.manager.getBatcher();
                Batch batch = batcher.createBatch();
                try {
                    session = this.manager.findSession(id);
                    if (session != null) break block12;
                    batch.close();
                    io.undertow.server.session.Session session2 = null;
                    return session2;
                }
                catch (Error | RuntimeException e) {
                    batch.discard();
                    batch.close();
                    throw e;
                }
            }
            DistributableSession result = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch(), closeTask);
            close = false;
            DistributableSession distributableSession = result;
            return distributableSession;
        }
        finally {
            if (close) {
                closeTask.run();
            }
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.listeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval(Duration.ofSeconds(timeout));
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    public io.undertow.server.session.Session getSession(String sessionId) {
        Throwable throwable = null;
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.viewSession(sessionId);
            DistributableImmutableSession distributableImmutableSession = session != null ? new DistributableImmutableSession(this, session) : null;
            return distributableImmutableSession;
        }
        catch (Error | RuntimeException e) {
            try {
                batch.discard();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public SessionManagerStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

