/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.function.LongFunction;
import org.wildfly.clustering.marshalling.spi.LongExternalizer;

public class DateExternalizer<D extends Date>
extends LongExternalizer<D> {
    DateExternalizer(LongFunction<D> factory, Class<D> targetClass) {
        super(targetClass, factory, Date::getTime);
    }

    public static class SqlTimestampExternalizer
    extends DateExternalizer<Timestamp> {
        public SqlTimestampExternalizer() {
            super(Timestamp::new, Timestamp.class);
        }

        @Override
        public void writeObject(ObjectOutput output, Timestamp timestamp) throws IOException {
            super.writeObject(output, timestamp);
            output.writeInt(timestamp.getNanos());
        }

        @Override
        public Timestamp readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Timestamp timestamp = (Timestamp)super.readObject(input);
            timestamp.setNanos(input.readInt());
            return timestamp;
        }
    }

    public static class SqlTimeExternalizer
    extends DateExternalizer<Time> {
        public SqlTimeExternalizer() {
            super(Time::new, Time.class);
        }
    }

    public static class SqlDateExternalizer
    extends DateExternalizer<java.sql.Date> {
        public SqlDateExternalizer() {
            super(java.sql.Date::new, java.sql.Date.class);
        }
    }

    public static class UtilDateExternalizer
    extends DateExternalizer<Date> {
        public UtilDateExternalizer() {
            super(Date::new, Date.class);
        }
    }
}

