/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.iiop.openjdk.IIOPRootDefinition;
import org.wildfly.iiop.openjdk.IIOPSubsystemParser_1;
import org.wildfly.iiop.openjdk.IIOPSubsystemParser_3;
import org.wildfly.iiop.openjdk.Namespace;
import org.wildfly.iiop.openjdk.SSLConfigValue;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

public class IIOPExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "iiop-openjdk";
    protected static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"iiop-openjdk");
    private static final String RESOURCE_NAME = IIOPExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final ModelVersion VERSION_1 = ModelVersion.create((int)1);
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append(".").append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, IIOPExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel((ResourceDefinition)IIOPRootDefinition.INSTANCE);
        subsystemRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new IIOPSubsystemParser_3());
        if (context.isRegisterTransformers()) {
            IIOPRootDefinition.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.IIOP_OPENJDK_1_0.getUriString(), IIOPSubsystemParser_1::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.IIOP_OPENJDK_3_0.getUriString(), IIOPSubsystemParser_3::new);
    }

    protected static void registerTransformers(SubsystemRegistration subsystem) {
        ChainedTransformationDescriptionBuilder chained = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)CURRENT_MODEL_VERSION);
        ResourceTransformationDescriptionBuilder builder = chained.createBuilder(CURRENT_MODEL_VERSION, VERSION_1);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{IIOPRootDefinition.SERVER_SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{IIOPRootDefinition.CLIENT_SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{IIOPRootDefinition.AUTHENTICATION_CONTEXT})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress pathAddress, String s, ModelNode attributeValue, TransformationContext transformationContext) {
                return attributeValue.asString().equals("true");
            }

            public String getRejectionLogMessage(Map<String, ModelNode> map) {
                return IIOPLogger.ROOT_LOGGER.serverRequiresSslNotSupportedInPreviousVersions();
            }
        }, new AttributeDefinition[]{IIOPRootDefinition.SERVER_REQUIRES_SSL})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress pathAddress, String s, ModelNode attributeValue, TransformationContext transformationContext) {
                return attributeValue.asString().equalsIgnoreCase("elytron");
            }

            public String getRejectionLogMessage(Map<String, ModelNode> map) {
                return IIOPLogger.ROOT_LOGGER.elytronInitializerNotSupportedInPreviousVersions();
            }
        }, new AttributeDefinition[]{IIOPRootDefinition.SECURITY})).setValueConverter(new AttributeConverter(){

            public void convertOperationParameter(PathAddress pathAddress, String s, ModelNode attributeValue, ModelNode operation, TransformationContext transformationContext) {
                this.convert(attributeValue);
            }

            public void convertResourceAttribute(PathAddress pathAddress, String s, ModelNode attributeValue, TransformationContext transformationContext) {
                this.convert(attributeValue);
            }

            private void convert(ModelNode attributeValue) {
                boolean clientRequiresSsl = attributeValue.asBoolean();
                if (clientRequiresSsl) {
                    attributeValue.set(SSLConfigValue.MUTUALAUTH.toString());
                } else {
                    attributeValue.set(SSLConfigValue.NONE.toString());
                }
            }
        }, new AttributeDefinition[]{IIOPRootDefinition.CLIENT_REQUIRES_SSL});
        chained.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{VERSION_1}});
    }
}

