/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class ReadSignedMail {
    private static final String BC = "BC";

    private static void verify(SMIMESigned s) throws Exception {
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)certIt.next());
            if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        if (msg.isMimeType("multipart/signed")) {
            SMIMESigned s = new SMIMESigned((MimeMultipart)msg.getContent());
            MimeBodyPart content = s.getContent();
            System.out.println("Content:");
            Object cont = content.getContent();
            if (cont instanceof String) {
                System.out.println((String)cont);
            } else if (cont instanceof Multipart) {
                Multipart mp = (Multipart)cont;
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    BodyPart m = mp.getBodyPart(i);
                    Object part = m.getContent();
                    System.out.println("Part " + i);
                    System.out.println("---------------------------");
                    if (part instanceof String) {
                        System.out.println((String)part);
                        continue;
                    }
                    System.out.println("can't print...");
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(s);
        } else if (msg.isMimeType("application/pkcs7-mime") || msg.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned s = new SMIMESigned((Part)msg);
            MimeBodyPart content = s.getContent();
            System.out.println("Content:");
            Object cont = content.getContent();
            if (cont instanceof String) {
                System.out.println((String)cont);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(s);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

