/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ModelVersionRange;
import org.jboss.dmr.ModelNode;

public final class ModelVersion
implements ModelVersionRange {
    public static final ModelVersion CURRENT = new ModelVersion(5, 0, 0);
    private final int major;
    private final int minor;
    private final int micro;

    ModelVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelVersion that = (ModelVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.micro != that.micro) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(".").append(this.minor).append(".").append(this.micro);
        return builder.toString();
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode();
        this.addToExistingModel(node);
        return node;
    }

    public void addToExistingModel(ModelNode node) {
        node.get("management-major-version").set(this.major);
        node.get("management-minor-version").set(this.minor);
        node.get("management-micro-version").set(this.micro);
    }

    @Override
    public ModelVersion[] getVersions() {
        return new ModelVersion[]{this};
    }

    public static ModelVersion create(int major) {
        return ModelVersion.create(major, 0, 0);
    }

    public static ModelVersion create(int major, int minor) {
        return ModelVersion.create(major, minor, 0);
    }

    public static ModelVersion create(int major, int minor, int micro) {
        return new ModelVersion(major, minor, micro);
    }

    public static ModelVersion fromString(String s) {
        return ModelVersion.convert(s);
    }

    static ModelVersion convert(String version) {
        String[] s = version.split("\\.");
        int length = s.length;
        if (length > 3) {
            throw new IllegalStateException();
        }
        int major = Integer.valueOf(s[0]);
        int minor = length > 1 ? Integer.valueOf(s[1]) : 0;
        int micro = length == 3 ? Integer.valueOf(s[2]) : 0;
        return ModelVersion.create(major, minor, micro);
    }

    public static int compare(ModelVersion versionA, ModelVersion versionB) {
        if (versionB.getMajor() > versionA.getMajor()) {
            return 1;
        }
        if (versionB.getMajor() < versionA.getMajor()) {
            return -1;
        }
        if (versionB.getMinor() > versionA.getMinor()) {
            return 1;
        }
        if (versionB.getMinor() < versionA.getMinor()) {
            return -1;
        }
        if (versionB.getMicro() > versionA.getMicro()) {
            return 1;
        }
        if (versionB.getMicro() < versionA.getMicro()) {
            return -1;
        }
        return 0;
    }
}

