/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.sql.Update;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class ValidityAuditStrategy
implements AuditStrategy {
    private Getter revisionTimestampGetter = null;
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void perform(Session session, final String entityName, final EnversService enversService, final Serializable id, final Object data, final Object revision) {
        AuditEntitiesConfiguration audEntitiesCfg = enversService.getAuditEntitiesConfiguration();
        final String auditedEntityName = audEntitiesCfg.getAuditEntityName(entityName);
        final String revisionInfoEntityName = enversService.getAuditEntitiesConfiguration().getRevisionInfoEntityName();
        session.save(auditedEntityName, data);
        final boolean reuseEntityIdentifier = enversService.getGlobalConfiguration().isAllowIdentifierReuse();
        if (reuseEntityIdentifier || this.getRevisionType(enversService, data) != RevisionType.ADD) {
            ((EventSource)session).getActionQueue().registerProcess(new BeforeTransactionCompletionProcess(){

                public void doBeforeTransactionCompletion(final SessionImplementor sessionImplementor) {
                    Queryable productionEntityQueryable = ValidityAuditStrategy.this.getQueryable(entityName, sessionImplementor);
                    final Queryable rootProductionEntityQueryable = ValidityAuditStrategy.this.getQueryable(productionEntityQueryable.getRootEntityName(), sessionImplementor);
                    Queryable auditedEntityQueryable = ValidityAuditStrategy.this.getQueryable(auditedEntityName, sessionImplementor);
                    final Queryable rootAuditedEntityQueryable = ValidityAuditStrategy.this.getQueryable(auditedEntityQueryable.getRootEntityName(), sessionImplementor);
                    String updateTableName = UnionSubclassEntityPersister.class.isInstance(rootProductionEntityQueryable) ? auditedEntityQueryable.getSubclassTableName(0) : rootAuditedEntityQueryable.getTableName();
                    final Type revisionInfoIdType = sessionImplementor.getFactory().getEntityPersister(revisionInfoEntityName).getIdentifierType();
                    String revEndColumnName = rootAuditedEntityQueryable.toColumns(enversService.getAuditEntitiesConfiguration().getRevisionEndFieldName())[0];
                    final boolean isRevisionEndTimestampEnabled = enversService.getAuditEntitiesConfiguration().isRevisionEndTimestampEnabled();
                    Update update = new Update(sessionImplementor.getFactory().getDialect()).setTableName(updateTableName);
                    update.addColumn(revEndColumnName);
                    if (isRevisionEndTimestampEnabled) {
                        update.addColumn(rootAuditedEntityQueryable.toColumns(enversService.getAuditEntitiesConfiguration().getRevisionEndTimestampFieldName())[0]);
                    }
                    update.addPrimaryKeyColumns(rootProductionEntityQueryable.getIdentifierColumnNames());
                    update.addWhereColumn(rootAuditedEntityQueryable.toColumns(enversService.getAuditEntitiesConfiguration().getRevisionNumberPath())[0], "<> ?");
                    update.addWhereColumn(revEndColumnName, " is null");
                    final String updateSql = update.toStatementString();
                    int rowCount = (Integer)((Session)sessionImplementor).doReturningWork((ReturningWork)new ReturningWork<Integer>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Integer execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = sessionImplementor.getJdbcCoordinator().getStatementPreparer().prepareStatement(updateSql);
                            try {
                                int index = 1;
                                Number revisionNumber = enversService.getRevisionInfoNumberReader().getRevisionNumber(revision);
                                revisionInfoIdType.nullSafeSet(preparedStatement, (Object)revisionNumber, index, sessionImplementor);
                                index += revisionInfoIdType.getColumnSpan((Mapping)sessionImplementor.getFactory());
                                if (isRevisionEndTimestampEnabled) {
                                    Object revEndTimestampObj = ValidityAuditStrategy.this.revisionTimestampGetter.get(revision);
                                    Date revisionEndTimestamp = ValidityAuditStrategy.this.convertRevEndTimestampToDate(revEndTimestampObj);
                                    Type revEndTsType = rootAuditedEntityQueryable.getPropertyType(enversService.getAuditEntitiesConfiguration().getRevisionEndTimestampFieldName());
                                    revEndTsType.nullSafeSet(preparedStatement, (Object)revisionEndTimestamp, index, sessionImplementor);
                                    index += revEndTsType.getColumnSpan((Mapping)sessionImplementor.getFactory());
                                }
                                Type idType = rootProductionEntityQueryable.getIdentifierType();
                                idType.nullSafeSet(preparedStatement, (Object)id, index, sessionImplementor);
                                Type revType = rootAuditedEntityQueryable.getPropertyType(enversService.getAuditEntitiesConfiguration().getRevisionNumberPath());
                                revType.nullSafeSet(preparedStatement, (Object)revisionNumber, index += idType.getColumnSpan((Mapping)sessionImplementor.getFactory()), sessionImplementor);
                                Integer n = sessionImplementor.getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                                return n;
                            }
                            finally {
                                sessionImplementor.getJdbcCoordinator().getResourceRegistry().release((Statement)preparedStatement);
                                sessionImplementor.getJdbcCoordinator().afterStatementExecution();
                            }
                        }
                    });
                    if (!(rowCount == 1 || reuseEntityIdentifier && ValidityAuditStrategy.this.getRevisionType(enversService, data) == RevisionType.ADD)) {
                        throw new RuntimeException("Cannot update previous revision for entity " + auditedEntityName + " and id " + id);
                    }
                }
            });
        }
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
    }

    private Queryable getQueryable(String entityName, SessionImplementor sessionImplementor) {
        return (Queryable)sessionImplementor.getFactory().getEntityPersister(entityName);
    }

    @Override
    public void performCollectionChange(Session session, String entityName, String propertyName, EnversService enversService, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        CollectionType collectionPropertyType;
        QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "ee__");
        String originalIdPropName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName();
        Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
        String revisionFieldName = enversService.getAuditEntitiesConfiguration().getRevisionFieldName();
        String revisionTypePropName = enversService.getAuditEntitiesConfiguration().getRevisionTypePropName();
        String ordinalPropName = enversService.getAuditEntitiesConfiguration().getEmbeddableSetOrdinalPropertyName();
        for (Map.Entry originalIdEntry : originalId.entrySet()) {
            if (revisionFieldName.equals(originalIdEntry.getKey()) || revisionTypePropName.equals(originalIdEntry.getKey()) || ordinalPropName.equals(originalIdEntry.getKey())) continue;
            qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
        }
        SessionFactoryImplementor sessionFactory = ((SessionImplementor)session).getFactory();
        Type propertyType = sessionFactory.getEntityPersister(entityName).getPropertyType(propertyName);
        if (propertyType.isCollectionType() && (collectionPropertyType = (CollectionType)propertyType).getElementType(sessionFactory) instanceof ComponentType) {
            for (Map.Entry<String, Object> dataEntry : persistentCollectionChangeData.getData().entrySet()) {
                if (originalIdPropName.equals(dataEntry.getKey())) continue;
                qb.getRootParameters().addWhereWithParam(dataEntry.getKey(), true, "=", dataEntry.getValue());
            }
        }
        this.addEndRevisionNullRestriction(enversService, qb.getRootParameters());
        List l = qb.toQuery(session).setLockOptions(LockOptions.UPGRADE).list();
        if (l.size() > 0) {
            this.updateLastRevision(session, enversService, l, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    private void addEndRevisionNullRestriction(EnversService enversService, Parameters rootParameters) {
        rootParameters.addWhere(enversService.getAuditEntitiesConfiguration().getRevisionEndFieldName(), true, "is", "null", false);
    }

    @Override
    public void addEntityAtRevisionRestriction(GlobalConfiguration globalCfg, QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2, boolean inclusive) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, String alias1, boolean inclusive, MiddleComponentData ... componentDatas) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    public void setRevisionTimestampGetter(Getter revisionTimestampGetter) {
        this.revisionTimestampGetter = revisionTimestampGetter;
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias, boolean inclusive) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, inclusive ? "<=" : "<", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, inclusive ? ">" : ">=", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(EnversService enversService, Object data) {
        return (RevisionType)((Object)((Map)data).get(enversService.getAuditEntitiesConfiguration().getRevisionTypePropName()));
    }

    private void updateLastRevision(Session session, EnversService enversService, List<Object> l, Object id, String auditedEntityName, Object revision) {
        Object previousData;
        if (l.size() == 1) {
            previousData = l.get(0);
            String revisionEndFieldName = enversService.getAuditEntitiesConfiguration().getRevisionEndFieldName();
            ((Map)previousData).put(revisionEndFieldName, revision);
            if (enversService.getAuditEntitiesConfiguration().isRevisionEndTimestampEnabled()) {
                String revEndTimestampFieldName = enversService.getAuditEntitiesConfiguration().getRevisionEndTimestampFieldName();
                Object revEndTimestampObj = this.revisionTimestampGetter.get(revision);
                Date revisionEndTimestamp = this.convertRevEndTimestampToDate(revEndTimestampObj);
                ((Map)previousData).put(revEndTimestampFieldName, revisionEndTimestamp);
            }
        } else {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        session.save(auditedEntityName, previousData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, previousData);
    }

    private Date convertRevEndTimestampToDate(Object revEndTimestampObj) {
        if (revEndTimestampObj instanceof Date) {
            return (Date)revEndTimestampObj;
        }
        return new Date((Long)revEndTimestampObj);
    }
}

