/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.JGroupsDefaultRequirement;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;

public class DiscoveryGroupAdd
extends AbstractAddStepHandler {
    public static final DiscoveryGroupAdd INSTANCE = new DiscoveryGroupAdd();

    private DiscoveryGroupAdd() {
        super(DiscoveryGroupDefinition.ATTRIBUTES);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String discoveryGroupName = context.getCurrentAddressValue();
        String serverName = context.getCurrentAddress().getParent().getLastElement().getValue();
        String compositeName = serverName + "." + discoveryGroupName;
        context.registerCapability(DiscoveryGroupDefinition.CHANNEL_FACTORY_CAPABILITY.fromBaseCapability(compositeName));
        ModelNode model = resource.getModel();
        if (CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, model).isDefined() && !DiscoveryGroupDefinition.JGROUPS_STACK.resolveModelAttribute(context, model).isDefined()) {
            context.registerAdditionalCapabilityRequirement(JGroupsDefaultRequirement.CHANNEL_FACTORY.getName(), RuntimeCapability.buildDynamicCapabilityName((String)DiscoveryGroupDefinition.CHANNEL_FACTORY_CAPABILITY.getName(), (String)compositeName), DiscoveryGroupDefinition.JGROUPS_STACK.getName());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            context.reloadRequired();
        } else {
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_CHANNEL.getName()) && model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                GroupBindingService bindingService = new GroupBindingService();
                target.addService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
            }
        }
    }

    static void addDiscoveryGroupConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("discovery-group")) {
            HashMap<String, DiscoveryGroupConfiguration> configs = configuration.getDiscoveryGroupConfigurations();
            if (configs == null) {
                configs = new HashMap<String, DiscoveryGroupConfiguration>();
                configuration.setDiscoveryGroupConfigurations(configs);
            }
            for (Property prop : model.get("discovery-group").asPropertyList()) {
                configs.put(prop.getName(), DiscoveryGroupAdd.createDiscoveryGroupConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int groupPort = socketBinding.getMulticastPort();
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        UDPBroadcastEndpointFactory endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(-1);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, JChannel channel, String channelName) throws Exception {
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        ChannelBroadcastEndpointFactory endpointFactory = new ChannelBroadcastEndpointFactory(channel, channelName);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

