/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.util.AnnotationExtractorViaEnumClass;
import ch.qos.cal10n.util.CAL10NBundleFinder;
import ch.qos.cal10n.util.CAL10NBundleFinderByClassloader;
import ch.qos.cal10n.verifier.AbstractMessageKeyVerifier;
import java.util.ArrayList;
import java.util.List;

public class MessageKeyVerifier
extends AbstractMessageKeyVerifier {
    final Class<? extends Enum<?>> enumClass;

    public MessageKeyVerifier(Class<? extends Enum<?>> enumClass) {
        super(enumClass.getName(), new AnnotationExtractorViaEnumClass(enumClass));
        this.enumClass = enumClass;
    }

    public MessageKeyVerifier(String enumTypeAsStr) {
        this(MessageKeyVerifier.buildEnumClass(enumTypeAsStr));
    }

    static Class<? extends Enum<?>> buildEnumClass(String enumClassAsStr) {
        String errMsg = "Failed to find enum class [" + enumClassAsStr + "]";
        try {
            return Class.forName(enumClassAsStr);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(errMsg, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException(errMsg, e);
        }
    }

    @Override
    protected List<String> extractKeysInEnum() {
        Enum<?>[] enumArray;
        ArrayList<String> enumKeyList = new ArrayList<String>();
        for (Enum<?> e : enumArray = this.enumClass.getEnumConstants()) {
            enumKeyList.add(e.toString());
        }
        return enumKeyList;
    }

    @Override
    protected CAL10NBundleFinder getResourceBundleFinder() {
        return new CAL10NBundleFinderByClassloader(this.enumClass.getClassLoader());
    }
}

