/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.util.Collections;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowEngine;

public class UndertowServer
implements Server {
    private final UndertowService service;
    private final Connector connector;

    public UndertowServer(UndertowService service, Connector connector) {
        this.service = service;
        this.connector = connector;
    }

    public Iterable<Engine> getEngines() {
        org.wildfly.extension.undertow.Server defaultServer = this.service.getServers().stream().filter(server -> server.getName().equals(this.service.getDefaultServer())).findFirst().get();
        return Collections.singleton(new UndertowEngine(defaultServer, this.service, this.connector));
    }

    public String toString() {
        return "org.wildfly.undertow";
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowServer)) {
            return false;
        }
        UndertowServer server = (UndertowServer)object;
        return this.service.equals(server.service);
    }

    public int hashCode() {
        return this.service.hashCode();
    }
}

