/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.tests.rt.transports.JGroupsTransport;
import org.jgroups.tests.rt.transports.NioTransport;
import org.jgroups.tests.rt.transports.ServerTransport;
import org.jgroups.tests.rt.transports.TcpTransport;
import org.jgroups.tests.rt.transports.UdpTransport;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class RoundTrip
implements RtReceiver {
    protected RtTransport tp;
    protected int num_msgs = 50000;
    protected int num_senders = 1;
    protected boolean details;
    protected boolean use_ms;
    protected static final byte REQ = 0;
    protected static final byte RSP = 1;
    protected static final byte DONE = 2;
    public static final int PAYLOAD = 11;
    protected Sender[] senders;
    protected final AverageMinMax req_latency = new AverageMinMax();
    protected final AverageMinMax rsp_latency = new AverageMinMax();
    protected static final Map<String, String> TRANSPORTS = new HashMap<String, String>(16);

    public RoundTrip(boolean use_ms) {
        this.use_ms = use_ms;
    }

    protected void start(String transport, String[] args) throws Exception {
        this.tp = RoundTrip.create(transport);
        this.tp.receiver(this);
        try {
            this.tp.start(args);
            this.loop();
        }
        finally {
            this.tp.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Object sender, byte[] req_buf, int offset, int length) {
        switch (req_buf[0]) {
            case 0: {
                short id = Bits.readShort(req_buf, 1);
                long time = RoundTrip.time(this.use_ms) - Bits.readLong(req_buf, 3);
                byte[] rsp_buf = new byte[11];
                rsp_buf[0] = 1;
                Bits.writeShort(id, rsp_buf, 1);
                try {
                    Bits.writeLong(RoundTrip.time(this.use_ms), rsp_buf, 3);
                    this.tp.send(sender, rsp_buf, 0, rsp_buf.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AverageMinMax averageMinMax = this.req_latency;
                synchronized (averageMinMax) {
                    this.req_latency.add(time);
                    break;
                }
            }
            case 1: {
                short id = Bits.readShort(req_buf, 1);
                long time = RoundTrip.time(this.use_ms) - Bits.readLong(req_buf, 3);
                this.senders[id].promise.setResult(true);
                AverageMinMax averageMinMax = this.rsp_latency;
                synchronized (averageMinMax) {
                    this.rsp_latency.add(time);
                    break;
                }
            }
            case 2: {
                System.out.printf(Util.bold("req-latency = min/avg/max: %d / %.2f / %d %s\n"), this.req_latency.min(), this.req_latency.average(), this.req_latency.max(), this.unit());
                this.req_latency.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("first byte needs to be either REQ or RSP but not " + req_buf[0]);
            }
        }
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            int c = Util.keyPress(String.format("[1] send [2] num_msgs (%d) [3] senders (%d)\n[d] details (%b) [x] exit\n", this.num_msgs, this.num_senders, this.details));
            try {
                switch (c) {
                    case 49: {
                        this.sendRequests();
                        break;
                    }
                    case 50: {
                        this.num_msgs = Util.readIntFromStdin("num_msgs: ");
                        break;
                    }
                    case 51: {
                        this.num_senders = Util.readIntFromStdin("num_senders: ");
                        break;
                    }
                    case 100: {
                        this.details = !this.details;
                        break;
                    }
                    case 120: {
                        looping = false;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void sendRequests() throws Exception {
        List<? extends Object> mbrs = this.tp.clusterMembers();
        if (mbrs != null && mbrs.size() != 2) {
            System.err.printf("Cluster must have exactly 2 members: %s\n", mbrs);
            return;
        }
        this.rsp_latency.clear();
        Object target = mbrs != null ? Util.pickNext(mbrs, this.tp.localAddress()) : null;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger sent_msgs = new AtomicInteger(0);
        this.senders = new Sender[this.num_senders];
        for (int i = 0; i < this.num_senders; ++i) {
            this.senders[i] = new Sender((short)i, latch, sent_msgs, target);
            this.senders[i].start();
        }
        long start = RoundTrip.time(this.use_ms);
        latch.countDown();
        for (Sender sender : this.senders) {
            sender.join();
        }
        long total_time = RoundTrip.time(this.use_ms) - start;
        byte[] done_buf = new byte[11];
        done_buf[0] = 2;
        this.tp.send(target, done_buf, 0, done_buf.length);
        double divisor = this.use_ms ? 1000.0 : 1000000.0;
        double msgs_sec = (double)this.num_msgs / ((double)total_time / divisor);
        AverageMinMax avg = null;
        if (this.details) {
            System.out.println("");
        }
        for (Sender sender : this.senders) {
            if (this.details) {
                System.out.printf("%d: %s\n", sender.id, this.print(sender.rtt));
            }
            if (avg == null) {
                avg = sender.rtt;
                continue;
            }
            avg.merge(sender.rtt);
        }
        System.out.printf(Util.bold("\n\nreqs/sec    = %.2f\nround-trip  = min/avg/max: %d / %.2f / %d %s\nrsp-latency = min/avg/max: %d / %.2f / %d %s\n\n"), msgs_sec, avg.min(), avg.average(), avg.max(), this.unit(), this.rsp_latency.min(), this.rsp_latency.average(), this.rsp_latency.max(), this.unit());
    }

    protected String print(AverageMinMax avg) {
        return String.format("round-trip min/avg/max = %d / %.2f / %d %s", avg.min(), avg.average(), avg.max(), this.unit());
    }

    protected static long time(boolean use_ms) {
        return use_ms ? System.currentTimeMillis() : Util.micros();
    }

    protected String unit() {
        return this.use_ms ? "ms" : "us";
    }

    public static void main(String[] args) throws Exception {
        String tp = "jg";
        boolean use_ms = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-tp")) {
                tp = args[++i];
                continue;
            }
            if (args[i].equals("-use-wall-clock")) {
                use_ms = true;
                continue;
            }
            if (!args[i].equals("-h")) continue;
            RoundTrip.help(tp);
            return;
        }
        RtTransport transport = RoundTrip.create(tp);
        String[] opts = transport.options();
        if (opts != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-tp") || args[i].equals("-h") || args[i].equals("-use-wall-clock") || !args[i].startsWith("-")) continue;
                String option = args[i];
                boolean match = false;
                for (String opt : opts) {
                    if (!opt.startsWith(option)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                RoundTrip.help(tp);
                return;
            }
        }
        new RoundTrip(use_ms).start(tp, args);
    }

    protected static void help(String transport) {
        RtTransport tp = null;
        try {
            tp = RoundTrip.create(transport);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.printf("\n%s [-tp classname | (%s)] [-use-wall-clock]\n          %s\n\n", RoundTrip.class.getSimpleName(), RoundTrip.availableTransports(), tp != null ? RoundTrip.printOptions(tp.options()) : "");
    }

    protected static RtTransport create(String transport) throws Exception {
        String clazzname = TRANSPORTS.get(transport);
        Class clazz = Util.loadClass(clazzname != null ? clazzname : transport, RoundTrip.class);
        return (RtTransport)clazz.newInstance();
    }

    protected static String availableTransports() {
        return Util.printListWithDelimiter(TRANSPORTS.keySet(), "|", 0, false);
    }

    protected static String printOptions(String[] opts) {
        if (opts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String opt : opts) {
            sb.append("[").append(opt).append("] ");
        }
        return sb.toString();
    }

    static {
        TRANSPORTS.put("jg", JGroupsTransport.class.getName());
        TRANSPORTS.put("jgroups", JGroupsTransport.class.getName());
        TRANSPORTS.put("tcp", TcpTransport.class.getName());
        TRANSPORTS.put("nio", NioTransport.class.getName());
        TRANSPORTS.put("server", ServerTransport.class.getName());
        TRANSPORTS.put("udp", UdpTransport.class.getName());
    }

    protected class Sender
    extends Thread {
        protected final short id;
        protected final CountDownLatch latch;
        protected final AtomicInteger sent_msgs;
        protected final Promise<Boolean> promise = new Promise();
        protected final int print;
        protected final Object target;
        protected final AverageMinMax rtt = new AverageMinMax();

        public Sender(short id, CountDownLatch latch, AtomicInteger sent_msgs, Object target) {
            this.id = id;
            this.latch = latch;
            this.sent_msgs = sent_msgs;
            this.target = target;
            this.print = Math.max(1, RoundTrip.this.num_msgs / 10);
        }

        @Override
        public void run() {
            int num;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while ((num = this.sent_msgs.getAndIncrement()) <= RoundTrip.this.num_msgs) {
                if (num > 0 && num % this.print == 0) {
                    System.out.printf(".", new Object[0]);
                }
                this.promise.reset(false);
                byte[] req_buf = new byte[11];
                req_buf[0] = 0;
                Bits.writeShort(this.id, req_buf, 1);
                try {
                    long start = RoundTrip.time(RoundTrip.this.use_ms);
                    Bits.writeLong(start, req_buf, 3);
                    RoundTrip.this.tp.send(this.target, req_buf, 0, req_buf.length);
                    this.promise.getResult(0L);
                    long time = RoundTrip.time(RoundTrip.this.use_ms) - start;
                    this.rtt.add(time);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

