/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

class OtpCredentialLoader
implements CredentialPersister {
    private final String algorithmAttributeName;
    private final String hashAttributeName;
    private final String seedAttributeName;
    private final String sequenceAttributeName;

    OtpCredentialLoader(String algorithmAttributeName, String hashAttributeName, String seedAttributeName, String sequenceAttributeName) {
        Assert.checkNotNullParam("algorithmAttributeName", algorithmAttributeName);
        Assert.checkNotNullParam("hashAttributeName", hashAttributeName);
        Assert.checkNotNullParam("seedAttributeName", seedAttributeName);
        Assert.checkNotNullParam("sequenceAttributeName", sequenceAttributeName);
        this.algorithmAttributeName = algorithmAttributeName;
        this.hashAttributeName = hashAttributeName;
        this.seedAttributeName = seedAttributeName;
        this.sequenceAttributeName = sequenceAttributeName;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        if (credentialType == PasswordCredential.class) {
            if (algorithmName == null) {
                return SupportLevel.SUPPORTED;
            }
            switch (algorithmName) {
                case "otp-md5": {
                    return SupportLevel.POSSIBLY_SUPPORTED;
                }
                case "otp-sha1": {
                    return SupportLevel.POSSIBLY_SUPPORTED;
                }
            }
            return SupportLevel.UNSUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public ForIdentityLoader forIdentity(DirContext context, String distinguishedName, Attributes attributes) {
        return new ForIdentityLoader(context, distinguishedName, attributes);
    }

    @Override
    public void addRequiredIdentityAttributes(Collection<String> attributes) {
        attributes.add(this.algorithmAttributeName);
        attributes.add(this.hashAttributeName);
        attributes.add(this.seedAttributeName);
        attributes.add(this.sequenceAttributeName);
    }

    private class ForIdentityLoader
    implements IdentityCredentialPersister {
        private final DirContext context;
        private final String distinguishedName;
        private final Attributes attributes;

        public ForIdentityLoader(DirContext context, String distinguishedName, Attributes attributes) {
            this.context = context;
            this.distinguishedName = distinguishedName;
            this.attributes = attributes;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Supplier<Provider[]> providers) {
            if (credentialType != PasswordCredential.class) {
                return SupportLevel.UNSUPPORTED;
            }
            Attribute algorithmAttribute = this.attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
            Attribute hashAttribute = this.attributes.get(OtpCredentialLoader.this.hashAttributeName);
            Attribute seedAttribute = this.attributes.get(OtpCredentialLoader.this.seedAttributeName);
            Attribute sequenceAttribute = this.attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
            if (algorithmAttribute != null && hashAttribute != null && seedAttribute != null && sequenceAttribute != null && (algorithmName == null || algorithmAttribute.contains(algorithmName))) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Supplier<Provider[]> providers) {
            block5: {
                if (credentialType != PasswordCredential.class) {
                    return null;
                }
                try {
                    Attribute algorithmAttribute = this.attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
                    Attribute hashAttribute = this.attributes.get(OtpCredentialLoader.this.hashAttributeName);
                    Attribute seedAttribute = this.attributes.get(OtpCredentialLoader.this.seedAttributeName);
                    Attribute sequenceAttribute = this.attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
                    if (algorithmAttribute == null || algorithmName != null && !algorithmAttribute.contains(algorithmName) || hashAttribute == null || seedAttribute == null || sequenceAttribute == null) {
                        return null;
                    }
                    PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithmAttribute.get(), providers);
                    Password password = passwordFactory.generatePassword(new OneTimePasswordSpec(CodePointIterator.ofString((String)hashAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), CodePointIterator.ofString((String)seedAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), Integer.parseInt((String)sequenceAttribute.get())));
                    if (credentialType.isAssignableFrom(PasswordCredential.class)) {
                        return (C)((Credential)credentialType.cast(new PasswordCredential(password)));
                    }
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException | NamingException e) {
                    if (!ElytronMessages.log.isTraceEnabled()) break block5;
                    ElytronMessages.log.trace("Getting OTP credential of type " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            return null;
        }

        @Override
        public boolean getCredentialPersistSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return OtpCredentialLoader.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec).mayBeSupported();
        }

        @Override
        public void persistCredential(Credential credential) throws RealmUnavailableException {
            OneTimePassword password = credential.castAndApply(PasswordCredential.class, c -> c.getPassword(OneTimePassword.class));
            try {
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(OtpCredentialLoader.this.algorithmAttributeName, password.getAlgorithm());
                attributes.put(OtpCredentialLoader.this.hashAttributeName, ByteIterator.ofBytes(password.getHash()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.seedAttributeName, ByteIterator.ofBytes(password.getSeed()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.sequenceAttributeName, Integer.toString(password.getSequenceNumber()));
                this.context.modifyAttributes(this.distinguishedName, 2, (Attributes)attributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            try {
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.algorithmAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.hashAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.seedAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.sequenceAttributeName));
                this.context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
        }
    }
}

