/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc;

import java.security.Principal;
import java.security.Provider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc.QueryConfiguration;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class JdbcSecurityRealm
implements CacheableSecurityRealm {
    private final Supplier<Provider[]> providers;
    private final List<QueryConfiguration> queryConfiguration;

    public static JdbcSecurityRealmBuilder builder() {
        return new JdbcSecurityRealmBuilder();
    }

    JdbcSecurityRealm(List<QueryConfiguration> queryConfiguration, Supplier<Provider[]> providers) {
        this.queryConfiguration = queryConfiguration;
        this.providers = providers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        if (!(principal instanceof NamePrincipal)) {
            return RealmIdentity.NON_EXISTENT;
        }
        return new JdbcRealmIdentity(principal.getName());
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        SupportLevel support = SupportLevel.UNSUPPORTED;
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                SupportLevel mapperSupport = keyMapper.getCredentialAcquireSupport(credentialType, algorithmName);
                if (support.compareTo(mapperSupport) >= 0) continue;
                support = mapperSupport;
            }
        }
        return support;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam("evidenceType", evidenceType);
        SupportLevel support = SupportLevel.UNSUPPORTED;
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                SupportLevel mapperSupport = keyMapper.getEvidenceVerifySupport(evidenceType, algorithmName);
                if (support.compareTo(mapperSupport) >= 0) continue;
                support = mapperSupport;
            }
        }
        return support;
    }

    @Override
    public void registerIdentityChangeListener(Consumer<Principal> listener) {
    }

    private static interface ResultSetCallback<E> {
        public E handle(ResultSet var1) throws SQLException;
    }

    private class JdbcRealmIdentity
    implements RealmIdentity {
        private final String name;
        private JdbcIdentity identity;

        public JdbcRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            SupportLevel support = SupportLevel.UNSUPPORTED;
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                    if (!keyMapper.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported()) continue;
                    SupportLevel mapperSupport = this.executePrincipalQuery(configuration, r -> keyMapper.getCredentialSupport(r, JdbcSecurityRealm.this.providers));
                    if (mapperSupport == SupportLevel.SUPPORTED) {
                        return SupportLevel.SUPPORTED;
                    }
                    if (mapperSupport != SupportLevel.POSSIBLY_SUPPORTED) continue;
                    support = SupportLevel.POSSIBLY_SUPPORTED;
                }
            }
            return support;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                    Credential credential;
                    if (!keyMapper.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported() || !credentialType.isInstance(credential = this.executePrincipalQuery(configuration, r -> keyMapper.map(r, JdbcSecurityRealm.this.providers)))) continue;
                    return (C)((Credential)credentialType.cast(credential));
                }
            }
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            SupportLevel support = SupportLevel.UNSUPPORTED;
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                    if (!keyMapper.getEvidenceVerifySupport(evidenceType, algorithmName).mayBeSupported()) continue;
                    SupportLevel mapperSupport = this.executePrincipalQuery(configuration, r -> keyMapper.getCredentialSupport(r, JdbcSecurityRealm.this.providers));
                    if (mapperSupport == SupportLevel.SUPPORTED) {
                        return SupportLevel.SUPPORTED;
                    }
                    if (mapperSupport != SupportLevel.POSSIBLY_SUPPORTED) continue;
                    support = SupportLevel.POSSIBLY_SUPPORTED;
                }
            }
            return support;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidence", evidence);
            if (this.exists()) {
                for (Credential credential : this.identity.credentials) {
                    if (!credential.canVerify(evidence)) continue;
                    return credential.verify(evidence);
                }
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getIdentity() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        private JdbcIdentity getIdentity() {
            if (this.identity == null) {
                this.identity = JdbcSecurityRealm.this.queryConfiguration.stream().map(queryConfiguration -> this.executePrincipalQuery((QueryConfiguration)queryConfiguration, resultSet -> {
                    if (resultSet.next()) {
                        MapAttributes attributes = new MapAttributes();
                        do {
                            queryConfiguration.getColumnMappers(AttributeMapper.class).forEach(attributeMapper -> {
                                try {
                                    Object value = attributeMapper.map(resultSet, JdbcSecurityRealm.this.providers);
                                    if (value != null) {
                                        attributes.addFirst(attributeMapper.getName(), value.toString());
                                    }
                                }
                                catch (SQLException cause) {
                                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(this.name, cause);
                                }
                            });
                        } while (resultSet.next());
                        return attributes;
                    }
                    return null;
                })).collect(Collectors.reducing((lAttribute, rAttribute) -> {
                    if (rAttribute == null) {
                        return lAttribute;
                    }
                    MapAttributes attributes = new MapAttributes((Attributes)lAttribute);
                    for (Attributes.Entry rEntry : rAttribute.entries()) {
                        attributes.get(rEntry.getKey()).addAll(rEntry);
                    }
                    return attributes;
                })).map(attributes -> {
                    ArrayList<Credential> credentials = new ArrayList<Credential>();
                    for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                        for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                            credentials.add(this.executePrincipalQuery(configuration, r -> keyMapper.map(r, JdbcSecurityRealm.this.providers)));
                        }
                    }
                    return new JdbcIdentity((Attributes)attributes, (List<Credential>)credentials);
                }).orElse(null);
            }
            return this.identity;
        }

        private Connection getConnection(QueryConfiguration configuration) {
            try {
                DataSource dataSource = configuration.getDataSource();
                return dataSource.getConnection();
            }
            catch (Exception e) {
                throw ElytronMessages.log.couldNotOpenConnection(e);
            }
        }

        /*
         * Exception decompiling
         */
        private <E> E executePrincipalQuery(QueryConfiguration configuration, ResultSetCallback<E> resultSetCallback) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class JdbcIdentity {
            private final Attributes attributes;
            private List<Credential> credentials = new ArrayList<Credential>();

            JdbcIdentity(Attributes attributes, List<Credential> credentials) {
                this.attributes = attributes;
                this.credentials = credentials;
            }
        }
    }
}

