/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslFactories;

public final class SecurityProviderSaslServerFactory
implements SaslServerFactory {
    private static final String SERVICE_TYPE = SaslServerFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderSaslServerFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = providerSupplier;
    }

    public SecurityProviderSaslServerFactory() {
        this(Security::getProviders);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services;
            if (currentProvider == null || !mechFilter.test(mechanism, currentProvider) || (services = currentProvider.getServices()) == null) continue;
            for (Provider.Service service : services) {
                if (!SERVICE_TYPE.equals(service.getType())) continue;
                try {
                    SaslServer saslServer = ((SaslServerFactory)service.newInstance(null)).createSaslServer(mechanism, protocol, serverName, props, cbh);
                    if (saslServer == null) continue;
                    return saslServer;
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug(e);
                }
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider supplier in %s: %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(this.providerSupplier.get()));
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        LinkedHashSet names = new LinkedHashSet();
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services = currentProvider.getServices();
            if (services == null) continue;
            for (Provider.Service service : services) {
                if (!SERVICE_TYPE.equals(service.getType())) continue;
                try {
                    String[] mechanismNames = ((SaslServerFactory)service.newInstance(null)).getMechanismNames(props);
                    Collections.addAll(names, SaslFactories.filterMechanismsByProvider(mechanismNames, 0, 0, currentProvider, mechFilter));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug(e);
                }
            }
        }
        if (names.size() == 0 && ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider supplier in %s: %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(this.providerSupplier.get()));
        }
        return names.toArray(new String[names.size()]);
    }
}

