/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.interception.ContainerResponseContextImpl;
import org.jboss.resteasy.core.interception.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.ServerWriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CommitHeaderOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ServerResponseWriter {
    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, final HttpResponse response, ResteasyProviderFactory providerFactory) throws IOException {
        Annotation[] annotations;
        ResourceMethodInvoker method = (ResourceMethodInvoker)request.getAttribute(ResourceMethodInvoker.class.getName());
        if (jaxrsResponse.getEntity() != null) {
            if (jaxrsResponse.getMediaType() == null) {
                ServerResponseWriter.setDefaultContentType(request, jaxrsResponse, providerFactory, method);
            }
            boolean addCharset = true;
            ResteasyDeployment deployment = ResteasyProviderFactory.getContextData(ResteasyDeployment.class);
            if (deployment != null) {
                addCharset = deployment.isAddCharset();
            }
            if (addCharset) {
                MediaType mt = null;
                Object o = jaxrsResponse.getHeaders().getFirst((Object)"Content-Type");
                mt = o instanceof MediaType ? (MediaType)o : MediaType.valueOf((String)o.toString());
                if (!mt.getParameters().containsKey("charset") && MediaTypeHelper.isTextLike(mt)) {
                    jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)mt.withCharset(StandardCharsets.UTF_8.toString()).toString());
                }
            }
        }
        ServerResponseWriter.executeFilters(jaxrsResponse, request, response, providerFactory, method);
        if (jaxrsResponse.getEntity() == null || response.getOutputStream() == null) {
            response.setStatus(jaxrsResponse.getStatus());
            ServerResponseWriter.commitHeaders(jaxrsResponse, response);
            return;
        }
        Class type = jaxrsResponse.getEntityClass();
        Object ent = jaxrsResponse.getEntity();
        Type generic = jaxrsResponse.getGenericType();
        MessageBodyWriter writer = providerFactory.getMessageBodyWriter(type, generic, annotations = jaxrsResponse.getAnnotations(), jaxrsResponse.getMediaType());
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
        }
        if (writer == null) {
            throw new NoMessageBodyWriterFoundFailure(type, jaxrsResponse.getMediaType());
        }
        response.setStatus(jaxrsResponse.getStatus());
        final BuiltResponse built = jaxrsResponse;
        CommitHeaderOutputStream.CommitCallback callback = new CommitHeaderOutputStream.CommitCallback(){
            private boolean committed;

            @Override
            public void commit() {
                if (this.committed) {
                    return;
                }
                this.committed = true;
                ServerResponseWriter.commitHeaders(built, response);
            }
        };
        CommitHeaderOutputStream os = new CommitHeaderOutputStream(response.getOutputStream(), callback);
        WriterInterceptor[] writerInterceptors = null;
        writerInterceptors = method != null ? method.getWriterInterceptors() : (WriterInterceptor[])providerFactory.getServerWriterInterceptorRegistry().postMatch(null, null);
        ServerWriterInterceptorContext writerContext = new ServerWriterInterceptorContext(writerInterceptors, providerFactory, ent, type, generic, annotations, jaxrsResponse.getMediaType(), jaxrsResponse.getMetadata(), os, request);
        writerContext.proceed();
        callback.commit();
    }

    private static void executeFilters(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) throws IOException {
        ContainerResponseFilter[] responseFilters = null;
        responseFilters = method != null ? method.getResponseFilters() : (ContainerResponseFilter[])providerFactory.getContainerResponseFilterRegistry().postMatch(null, null);
        if (responseFilters != null) {
            ResponseContainerRequestContext requestContext = new ResponseContainerRequestContext(request);
            ContainerResponseContextImpl responseContext = new ContainerResponseContextImpl(request, response, jaxrsResponse);
            for (ContainerResponseFilter filter : responseFilters) {
                filter.filter((ContainerRequestContext)requestContext, (ContainerResponseContext)responseContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void setDefaultContentType(HttpRequest request, BuiltResponse jaxrsResponse, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType chosen = (MediaType)request.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        boolean hasProduces = chosen != null && Boolean.valueOf((String)chosen.getParameters().get("RESTEASY-SERVER-HAS-PRODUCES")) != false;
        hasProduces |= method != null && method.getProduces() != null && method.getProduces().length > 0;
        if (hasProduces |= method != null && method.getMethod().getClass().getAnnotation(Produces.class) != null) {
            if ((chosen == null || chosen.isWildcardSubtype()) && method != null) {
                if (method.getProduces().length > 0) {
                    for (MediaType mediaType : method.getProduces()) {
                        if (mediaType.isWildcardType()) continue;
                        chosen = mediaType;
                        if (mediaType.isWildcardSubtype()) {
                            continue;
                        }
                        break;
                    }
                } else {
                    method.getMethod().getClass().getAnnotation(Produces.class);
                    for (String string : method.getMethod().getClass().getAnnotation(Produces.class).value()) {
                        MediaType produce = MediaType.valueOf((String)string);
                        if (produce.isWildcardType()) continue;
                        chosen = produce;
                        if (produce.isWildcardSubtype()) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else {
            void var9_21;
            Annotation[] annotationArray;
            if (chosen == null) {
                chosen = MediaType.WILDCARD_TYPE;
            }
            Class clazz = jaxrsResponse.getEntityClass();
            Object ent = jaxrsResponse.getEntity();
            Type generic = jaxrsResponse.getGenericType();
            if (generic == null) {
                generic = method != null && !Response.class.isAssignableFrom(method.getMethod().getReturnType()) ? method.getGenericReturnType() : clazz;
            }
            if ((annotationArray = jaxrsResponse.getAnnotations()) == null && method != null) {
                Annotation[] annotationArray2 = method.getMethodAnnotations();
            }
            List<MessageBodyWriter<?>> mbrs = providerFactory.getPossibleMessageBodyWriters(clazz, generic, (Annotation[])var9_21);
            List accepts = request.getHttpHeaders().getAcceptableMediaTypes();
            ArrayList<SortableMediaType> M = new ArrayList<SortableMediaType>();
            for (MediaType accept : accepts) {
                for (MessageBodyWriter<?> mbr : mbrs) {
                    Produces produces = mbr.getClass().getAnnotation(Produces.class);
                    for (String producesString : produces.value()) {
                        MediaType produce = MediaType.valueOf((String)producesString);
                        if (!produce.isCompatible(accept)) continue;
                        M.add(ServerResponseWriter.mostSpecific(produce, accept));
                    }
                }
            }
            if (M.size() > 0) {
                Collections.sort(M);
                chosen = (MediaType)M.get(M.size() - 1);
            }
        }
        if (chosen.isWildcardType()) {
            chosen = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        } else if (chosen.isWildcardSubtype() && chosen.getSubtype().equals("application")) {
            chosen = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        } else if (chosen.isWildcardSubtype()) {
            throw new NotAcceptableException(Messages.MESSAGES.illegalResponseMediaType(chosen.toString()));
        }
        if (chosen.getParameters().containsKey("RESTEASY-SERVER-HAS-PRODUCES")) {
            HashMap hashMap = new HashMap(chosen.getParameters());
            hashMap.remove("RESTEASY-SERVER-HAS-PRODUCES");
            hashMap.remove("RESTEASY-SERVER-HAS-PRODUCES".toLowerCase());
            chosen = new MediaType(chosen.getType(), chosen.getSubtype(), hashMap);
        }
        jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)chosen);
    }

    public static MediaType resolveContentType(BuiltResponse response) {
        MediaType responseContentType = null;
        Object type = response.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public static void commitHeaders(BuiltResponse jaxrsResponse, HttpResponse response) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll(jaxrsResponse.getMetadata());
        }
    }

    private static SortableMediaType mostSpecific(MediaType m1, MediaType m2) {
        Object m = null;
        if (m1.getType().equals("*")) {
            if (m2.getType().equals("*")) {
                if (m1.getSubtype().equals("*")) {
                    return new SortableMediaType(m2);
                }
                return new SortableMediaType(m1);
            }
            return new SortableMediaType(m2);
        }
        if (m2.getType().equals("*")) {
            return new SortableMediaType(m1);
        }
        if (m1.getSubtype().equals("*")) {
            return new SortableMediaType(m2);
        }
        return new SortableMediaType(m1);
    }

    private static class SortableMediaType
    extends MediaType
    implements Comparable<SortableMediaType> {
        double q = -1.0;
        double qs = -1.0;

        public SortableMediaType(MediaType m) {
            this(m.getType(), m.getSubtype(), m.getParameters());
        }

        public SortableMediaType(String type, String subtype, Map<String, String> parameters) {
            super(type, subtype, parameters);
            String qsString;
            String qString = parameters.get("q");
            if (qString != null) {
                try {
                    this.q = Double.valueOf(qString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.q < 0.0 && (qsString = parameters.get("qs")) != null) {
                try {
                    this.qs = Double.valueOf(qsString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int compareTo(SortableMediaType o) {
            if (this.isCompatible(o)) {
                if (this.equals(o)) {
                    return 0;
                }
                SortableMediaType mostSpecific = ServerResponseWriter.mostSpecific(this, o);
                return this.equals(ServerResponseWriter.mostSpecific(this, o)) ? 1 : -1;
            }
            if (this.q < o.q) {
                return -1;
            }
            if (this.q > o.q) {
                return 1;
            }
            if (this.qs < o.qs) {
                return -1;
            }
            if (this.qs > o.qs) {
                return 1;
            }
            return 0;
        }
    }
}

